BEGIN TRANSACTION;
CREATE TABLE IF NOT EXISTS "auth_group" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(150) NOT NULL UNIQUE);
CREATE TABLE IF NOT EXISTS "auth_group_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "auth_permission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content_type_id" integer NOT NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "codename" varchar(100) NOT NULL, "name" varchar(255) NOT NULL);
CREATE TABLE IF NOT EXISTS "auth_user" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "password" varchar(128) NOT NULL, "last_login" datetime NULL, "is_superuser" bool NOT NULL, "username" varchar(150) NOT NULL UNIQUE, "last_name" varchar(150) NOT NULL, "email" varchar(254) NOT NULL, "is_staff" bool NOT NULL, "is_active" bool NOT NULL, "date_joined" datetime NOT NULL, "first_name" varchar(150) NOT NULL);
CREATE TABLE IF NOT EXISTS "auth_user_groups" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "auth_user_user_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "django_admin_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "object_id" text NULL, "object_repr" varchar(200) NOT NULL, "action_flag" smallint unsigned NOT NULL CHECK ("action_flag" >= 0), "change_message" text NOT NULL, "content_type_id" integer NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "action_time" datetime NOT NULL);
CREATE TABLE IF NOT EXISTS "django_content_type" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app_label" varchar(100) NOT NULL, "model" varchar(100) NOT NULL);
CREATE TABLE IF NOT EXISTS "django_migrations" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "applied" datetime NOT NULL);
CREATE TABLE IF NOT EXISTS "django_session" ("session_key" varchar(40) NOT NULL PRIMARY KEY, "session_data" text NOT NULL, "expire_date" datetime NOT NULL);
CREATE TABLE IF NOT EXISTS "messaging_client" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL, "phone_number" varchar(20) NOT NULL, "last_contacted" datetime NULL);
CREATE TABLE IF NOT EXISTS "messaging_twiliochatmessage" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "message_sid" varchar(255) NOT NULL UNIQUE, "author" varchar(255) NOT NULL, "body" text NOT NULL, "date_created" datetime NOT NULL, "channel_sid" varchar(255) NOT NULL);
CREATE TABLE IF NOT EXISTS "projects_attachment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "file" varchar(100) NOT NULL, "created_at" datetime NOT NULL, "uploaded_by_id" integer NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "task_id" bigint NOT NULL REFERENCES "projects_task" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "projects_comment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content" text NOT NULL, "created_at" datetime NOT NULL, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "task_id" bigint NOT NULL REFERENCES "projects_task" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "projects_dailytaskupdate" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "date" date NOT NULL, "status" varchar(20) NOT NULL, "remarks" text NOT NULL, "progress_percent" integer unsigned NOT NULL CHECK ("progress_percent" >= 0), "updated_by_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "task_id" bigint NOT NULL REFERENCES "projects_task" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "projects_project" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL, "start_date" date NOT NULL, "end_date" date NOT NULL, "status" varchar(20) NOT NULL, "created_at" datetime NOT NULL, "created_by_id" integer NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "backend_percentage" real NOT NULL, "bug_solve_percentage" real NOT NULL, "final_bug_solve_percentage" real NOT NULL, "mobile_app_percentage" real NOT NULL, "production_percentage" real NOT NULL, "retest_percentage" real NOT NULL, "testing_percentage" real NOT NULL, "ui_percentage" real NOT NULL, "project_progress_in_id" bigint NULL REFERENCES "teams_team" ("id") DEFERRABLE INITIALLY DEFERRED, "backend_days" integer unsigned NOT NULL CHECK ("backend_days" >= 0), "bug_solve_days" integer unsigned NOT NULL CHECK ("bug_solve_days" >= 0), "final_bug_solve_days" integer unsigned NOT NULL CHECK ("final_bug_solve_days" >= 0), "mobile_app_days" integer unsigned NOT NULL CHECK ("mobile_app_days" >= 0), "production_days" integer unsigned NOT NULL CHECK ("production_days" >= 0), "retest_days" integer unsigned NOT NULL CHECK ("retest_days" >= 0), "testing_days" integer unsigned NOT NULL CHECK ("testing_days" >= 0), "ui_days" integer unsigned NOT NULL CHECK ("ui_days" >= 0), "frontend_days" integer unsigned NOT NULL CHECK ("frontend_days" >= 0), "frontend_percentage" real NOT NULL, "project_type" bool NOT NULL, "status_details" text NULL);
CREATE TABLE IF NOT EXISTS "projects_projectdocument" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "document" varchar(100) NOT NULL, "uploaded_at" datetime NOT NULL, "project_id" bigint NOT NULL REFERENCES "projects_project" ("id") DEFERRABLE INITIALLY DEFERRED, "uploaded_by_id" integer NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "projects_projectfeedback" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "project_id" bigint NOT NULL REFERENCES "projects_project" ("id") DEFERRABLE INITIALLY DEFERRED, "created_at" datetime NOT NULL, "date" date NOT NULL);
CREATE TABLE IF NOT EXISTS "projects_projectfeedback_users_to_notify" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "projectfeedback_id" bigint NOT NULL REFERENCES "projects_projectfeedback" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "projects_projectfeedbackimage" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "feedback_id" bigint NOT NULL REFERENCES "projects_projectfeedback" ("id") DEFERRABLE INITIALLY DEFERRED, "content" text NULL, "image" varchar(100) NULL);
CREATE TABLE IF NOT EXISTS "projects_task" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "title" varchar(255) NOT NULL, "description" text NOT NULL, "status" varchar(20) NOT NULL, "priority" varchar(10) NOT NULL, "start_date" date NOT NULL, "due_date" date NOT NULL, "completed_at" date NULL, "created_at" datetime NOT NULL, "assigned_by_id" integer NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "assigned_to_id" integer NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "project_id" bigint NOT NULL REFERENCES "projects_project" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "projects_teamprogress" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "assigned_start_date" date NOT NULL, "expected_end_date" date NOT NULL, "actual_end_date" date NULL, "rework_start_date" date NULL, "rework_end_date" date NULL, "delay_reason" varchar(20) NOT NULL, "remarks" text NULL, "updated_at" datetime NOT NULL, "project_id" bigint NOT NULL REFERENCES "projects_project" ("id") DEFERRABLE INITIALLY DEFERRED, "team_id" bigint NOT NULL REFERENCES "teams_team" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "teams_team" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL, "created_at" datetime NOT NULL);
CREATE TABLE IF NOT EXISTS "teams_teammember" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "team_id" bigint NOT NULL REFERENCES "teams_team" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL UNIQUE REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "auth_group" ("id","name") VALUES (1,'Team Leader'),
 (2,'Team Member');
INSERT INTO "auth_group_permissions" ("id","group_id","permission_id") VALUES (1,1,36),
 (2,1,37),
 (3,1,38),
 (4,1,39),
 (5,1,40),
 (6,2,40),
 (7,1,56),
 (8,1,53),
 (9,1,54),
 (10,1,55),
 (11,2,53),
 (12,2,54),
 (14,2,56),
 (15,2,57),
 (16,2,58),
 (18,2,60),
 (19,1,57),
 (20,1,58),
 (21,1,59),
 (22,1,60);
INSERT INTO "auth_permission" ("id","content_type_id","codename","name") VALUES (1,1,'add_logentry','Can add log entry'),
 (2,1,'change_logentry','Can change log entry'),
 (3,1,'delete_logentry','Can delete log entry'),
 (4,1,'view_logentry','Can view log entry'),
 (5,2,'add_permission','Can add permission'),
 (6,2,'change_permission','Can change permission'),
 (7,2,'delete_permission','Can delete permission'),
 (8,2,'view_permission','Can view permission'),
 (9,3,'add_group','Can add group'),
 (10,3,'change_group','Can change group'),
 (11,3,'delete_group','Can delete group'),
 (12,3,'view_group','Can view group'),
 (13,4,'add_user','Can add user'),
 (14,4,'change_user','Can change user'),
 (15,4,'delete_user','Can delete user'),
 (16,4,'view_user','Can view user'),
 (17,5,'add_contenttype','Can add content type'),
 (18,5,'change_contenttype','Can change content type'),
 (19,5,'delete_contenttype','Can delete content type'),
 (20,5,'view_contenttype','Can view content type'),
 (21,6,'add_session','Can add session'),
 (22,6,'change_session','Can change session'),
 (23,6,'delete_session','Can delete session'),
 (24,6,'view_session','Can view session'),
 (25,7,'add_team','Can add team'),
 (26,7,'change_team','Can change team'),
 (27,7,'delete_team','Can delete team'),
 (28,7,'view_team','Can view team'),
 (29,8,'add_teammember','Can add team member'),
 (30,8,'change_teammember','Can change team member'),
 (31,8,'delete_teammember','Can delete team member'),
 (32,8,'view_teammember','Can view team member'),
 (33,9,'add_project','Can add project'),
 (34,9,'change_project','Can change project'),
 (35,9,'delete_project','Can delete project'),
 (36,9,'view_project','Can view project'),
 (37,10,'add_task','Can add task'),
 (38,10,'change_task','Can change task'),
 (39,10,'delete_task','Can delete task'),
 (40,10,'view_task','Can view task'),
 (41,11,'add_comment','Can add comment'),
 (42,11,'change_comment','Can change comment'),
 (43,11,'delete_comment','Can delete comment'),
 (44,11,'view_comment','Can view comment'),
 (45,12,'add_attachment','Can add attachment'),
 (46,12,'change_attachment','Can change attachment'),
 (47,12,'delete_attachment','Can delete attachment'),
 (48,12,'view_attachment','Can view attachment'),
 (49,13,'add_notification','Can add notification'),
 (50,13,'change_notification','Can change notification'),
 (51,13,'delete_notification','Can delete notification'),
 (52,13,'view_notification','Can view notification'),
 (53,14,'add_taskstatusupdate','Can add task status update'),
 (54,14,'change_taskstatusupdate','Can change task status update'),
 (55,14,'delete_taskstatusupdate','Can delete task status update'),
 (56,14,'view_taskstatusupdate','Can view task status update'),
 (57,15,'add_dailytaskupdate','Can add daily task update'),
 (58,15,'change_dailytaskupdate','Can change daily task update'),
 (59,15,'delete_dailytaskupdate','Can delete daily task update'),
 (60,15,'view_dailytaskupdate','Can view daily task update'),
 (61,16,'add_client','Can add client'),
 (62,16,'change_client','Can change client'),
 (63,16,'delete_client','Can delete client'),
 (64,16,'view_client','Can view client'),
 (65,17,'add_whatsappmessage','Can add whats app message'),
 (66,17,'change_whatsappmessage','Can change whats app message'),
 (67,17,'delete_whatsappmessage','Can delete whats app message'),
 (68,17,'view_whatsappmessage','Can view whats app message'),
 (69,18,'add_twiliochatmessage','Can add twilio chat message'),
 (70,18,'change_twiliochatmessage','Can change twilio chat message'),
 (71,18,'delete_twiliochatmessage','Can delete twilio chat message'),
 (72,18,'view_twiliochatmessage','Can view twilio chat message'),
 (73,19,'add_projectdocument','Can add project document'),
 (74,19,'change_projectdocument','Can change project document'),
 (75,19,'delete_projectdocument','Can delete project document'),
 (76,19,'view_projectdocument','Can view project document'),
 (77,20,'add_projectfeedback','Can add project feedback'),
 (78,20,'change_projectfeedback','Can change project feedback'),
 (79,20,'delete_projectfeedback','Can delete project feedback'),
 (80,20,'view_projectfeedback','Can view project feedback'),
 (81,21,'add_projectfeedbackimage','Can add project feedback image'),
 (82,21,'change_projectfeedbackimage','Can change project feedback image'),
 (83,21,'delete_projectfeedbackimage','Can delete project feedback image'),
 (84,21,'view_projectfeedbackimage','Can view project feedback image'),
 (85,22,'add_teamprogress','Can add team progress'),
 (86,22,'change_teamprogress','Can change team progress'),
 (87,22,'delete_teamprogress','Can delete team progress'),
 (88,22,'view_teamprogress','Can view team progress');
INSERT INTO "auth_user" ("id","password","last_login","is_superuser","username","last_name","email","is_staff","is_active","date_joined","first_name") VALUES (1,'pbkdf2_sha256$1000000$PHCdGSZCx8FKRTrElQghvP$ajJsNtUuX8AWD1vNEvaM5qE5E55RT7W6tZd4JaleXmE=','2025-07-08 10:59:26.163454',1,'admin@gmail.com','','admin@gmail.com',1,1,'2025-05-19 10:49:37.626128',''),
 (2,'pbkdf2_sha256$600000$ahHHJ42CUKtfbCKQGCFcDV$hywzvYJcSckzkLfu5r55MCq8Jy12STty+MVgyELH6+I=','2025-05-22 07:16:15.038813',0,'oshin.kawale@profcyma.com','Kawale','oshin.kawale@profcyma.com',1,1,'2025-05-19 12:37:57','Oshin'),
 (3,'pbkdf2_sha256$600000$jPNp4oZujFZencxp5LwWKb$VTserP8ETmifkJs3BQlcqLT+SAC/tuDsZCr290TEN5w=','2025-05-22 11:48:29.621034',0,'sanket.thawari@profcyma.in','Thawari','sanket.thawari@profcyma.in',1,1,'2025-05-21 12:15:38','Sanket'),
 (4,'pbkdf2_sha256$600000$LkbTLLtYChf2ETJt0jYqqT$C5KUOH4DuiY8RONbED1aU61X4PFY5Cox3VVwuMo0wPA=','2025-05-23 07:39:33.139502',0,'ankur.jain@profcyma.in','Jain','ankur.jain@profcyma.in',1,1,'2025-05-21 12:49:30','Ankur'),
 (5,'pbkdf2_sha256$600000$To52Ol8qW4zgnFOv5HIHet$0hRyRjeOEqSyJNvRWg+YSSE0FoZN/dhCqD/mS/1VwbY=',NULL,0,'kalyani.raghatate@profcyma.in','Raghatate','kalyani.raghatate@profcyma.in',1,1,'2025-05-23 11:55:49','Kalyani'),
 (6,'pbkdf2_sha256$600000$Gb4nTTCPTIBcNLGen16gMZ$K6KjR/0z0rS1ZCuwp7Cfa9T3AucsSNkX6Aq5JDa46pI=',NULL,0,'aditya.jagtap@profcyma.in','Jagtap','aditya.jagtap@profcyma.in',1,1,'2025-05-23 11:57:07','Aditya'),
 (7,'pbkdf2_sha256$600000$Y9uxXGyIiHutMxEs2rNFdx$7CyTzEeGu440rkkxgyI676tR9FRhLDl3mNknlC+ZqoI=',NULL,0,'paresh.markad@profcyma.in','Markad','paresh.markad@profcyma.in',1,1,'2025-05-27 11:45:53','Paresh'),
 (8,'pbkdf2_sha256$600000$8Sp59f4AUcxklDuCVMICjS$P3NphFqfsMCHitdmxS3YGUPzgPEu+xRjJH1YgAdVxzk=',NULL,0,'pratiksha.pethe@profcyma.in','Pethe','pratiksha.pethe@profcyma.in',1,1,'2025-05-28 07:13:50','Pratiksha'),
 (9,'pbkdf2_sha256$600000$PWbRi1tb8QBVHUrZ9mWA2z$c8HxRo3vi3G/Mn2vwAPfR1lVAXBKStC+UVPv4klaamU=',NULL,0,'sonu.buradkar@profcyma.in','Buradkar','sonu.buradkar@profcyma.in',1,1,'2025-05-28 07:15:14','Sonu'),
 (10,'pbkdf2_sha256$600000$5PWxyj9DowtjmwUSL2v36y$Elq1wRODUAJIS3C/nrTiT+srr7YRVDLJpcnOjZpEVWc=',NULL,0,'prathmesh.raut@profcyma.in','Raut','prathmesh.raut@profcyma.in',1,1,'2025-05-28 07:16:46','Prathmesh'),
 (11,'pbkdf2_sha256$600000$y2bfxsxduNb35cV7ZTp69E$uexJMWrk/YSBOa5ZoG61gyb4hwDPR5ZyqnNbPfMJ4TU=',NULL,0,'kirankumar.falmari@profcyma.in','Falmari','kirankumar.falmari@profcyma.in',1,1,'2025-05-28 07:17:59','Kiran'),
 (12,'pbkdf2_sha256$600000$KtewfO7qvEJlJ437104fcR$GQyWrGoMWk27tNfoqJLpQJlZiq8GQPgw6JyyMULkIjE=',NULL,0,'yuktesh.jadhav@profcyma.in','Jadhav','yuktesh.jadhav@profcyma.in',1,1,'2025-05-28 07:20:26','Yuktesh'),
 (13,'pbkdf2_sha256$600000$9LykSlKuebiMqRHiBlHKvo$sHvP0QBZV7fgR2/xTPBfoqUHKZutElYjb8fnvs1D3jI=',NULL,0,'abhishek.thakur@profcyma.in','Thakur','abhishek.thakur@profcyma.in',1,1,'2025-05-28 07:21:44','Abhishek'),
 (14,'pbkdf2_sha256$600000$hfj4zmsySfiqGQPsR8UirK$t7/Ms9/XkHCDqPlucZxjl91eGvyuHjz62QVnPXG6s+w=',NULL,0,'omkar.nilakhe@profcyma.in','Nilakhe','omkar.nilakhe@profcyma.in',1,1,'2025-05-28 07:23:48','Omkar'),
 (15,'pbkdf2_sha256$600000$bUL2UR0XGQuAjdgwr9w3mP$+S4UYAEOH7bHNzmcmLy4g33TcxCSSEHoj9Adpva+ISE=',NULL,0,'tejas.langote@profcyma.in','Langote','tejas.langote@profcyma.in',1,1,'2025-05-28 08:58:26','Tejas'),
 (16,'pbkdf2_sha256$600000$UMKbSKHlAHwx1hhwzPXh7W$XO4UDg9GcOKSPLFqSNih6Z8yQxj8fYkTuNJUhcQbglw=',NULL,0,'poonam.chawariya@profcyma.in','Chawariya','poonam.chawariya@profcyma.in',1,1,'2025-05-28 09:00:00','Poonam'),
 (17,'pbkdf2_sha256$1000000$3BdOyIKh3p4jQ741J90QB5$zKzQxWkW9z6xAkmU8I2i/k4CywlR01kPmrl0x85hJTc=',NULL,1,'guddu.kumar@profcyma.com','Kumar','guddu.kumar@profcyma.com',0,1,'2025-07-03 08:43:35','Guddu'),
 (18,'pbkdf2_sha256$1000000$Mln4IV2lgQi9bDToIEu7qO$Wp89BdNPAqw6aPU0xzZVvwECCiQP7gCwVU5vfqMVY3I=',NULL,0,'sakshi.gawande@profcyma.in','Gawande','sakshi.gawande@profcyma.in',1,1,'2025-07-04 04:39:46','Sakshi'),
 (19,'pbkdf2_sha256$1000000$Oy9uPIPsGytKHAbLxGMGcu$P92rOhUbAY+mh5rfcLoNOWhWq7OqSwe0vcIdtuUpz30=',NULL,0,'prajwal.narkhede@profcyma.in','Narkhede','prajwal.narkhede@profcyma.in',1,1,'2025-07-04 04:43:47','Prajwal'),
 (20,'pbkdf2_sha256$1000000$d59fW840d5RCqMdxZ1nTqZ$J6+KtO0XsrqjnLOENz396bs4k7+61vTNReFhMu929IQ=',NULL,0,'yash.deshmukh@profcyma.in','Deshmukh','yash.deshmukh@profcyma.in',1,1,'2025-07-08 04:57:37','Yash');
INSERT INTO "auth_user_groups" ("id","user_id","group_id") VALUES (1,4,2),
 (2,3,1),
 (3,2,1),
 (4,5,2),
 (5,6,1),
 (6,7,1),
 (7,8,2),
 (8,9,2),
 (9,10,2),
 (10,11,2),
 (11,12,2),
 (12,13,2),
 (13,14,2),
 (14,15,1),
 (15,16,2),
 (16,19,1),
 (17,18,2),
 (18,20,2);
INSERT INTO "django_admin_log" ("id","object_id","object_repr","action_flag","change_message","content_type_id","user_id","action_time") VALUES (1,'1','Ui/Ux',1,'[{"added": {}}]',7,1,'2025-05-19 11:22:19.290333'),
 (2,'1','Test Project',1,'[{"added": {}}]',9,1,'2025-05-19 11:22:26.254368'),
 (3,'2','sanket@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-19 12:37:57.567626'),
 (4,'1','sanket@profcyma.in - Ui/Ux',1,'[{"added": {}}]',8,1,'2025-05-19 12:38:03.161930'),
 (5,'1','ZXCx',1,'[{"added": {}}]',10,1,'2025-05-19 14:27:44.103008'),
 (6,'1','To Create Crud',2,'[{"changed": {"fields": ["Title", "Description"]}}]',10,1,'2025-05-20 09:24:39.906310'),
 (7,'1','Notification object (1)',1,'[{"added": {}}]',13,1,'2025-05-20 10:06:36.667947'),
 (8,'2','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["Username"]}}]',4,1,'2025-05-20 10:14:49.116841'),
 (9,'2','To Add Driwe project',1,'[{"added": {}}]',10,1,'2025-05-20 10:18:08.521649'),
 (10,'2','oshin.kawale@profcyma.com',2,'[{"changed": {"fields": ["Username"]}}]',4,1,'2025-05-20 10:19:28.359888'),
 (11,'1','oshin.kawale@profcyma.com - Ui/Ux',2,'[]',8,1,'2025-05-20 10:19:30.395987'),
 (12,'1','To Create Crud',2,'[]',10,1,'2025-05-20 10:23:06.564402'),
 (13,'3','This',1,'[{"added": {}}]',10,1,'2025-05-20 10:27:13.788371'),
 (14,'4','sss',1,'[{"added": {}}]',10,1,'2025-05-20 10:30:21.191140'),
 (15,'5','aSsS',1,'[{"added": {}}]',10,1,'2025-05-20 10:31:37.546135'),
 (16,'5','aSsS',2,'[]',10,1,'2025-05-20 14:15:13.648699'),
 (17,'2','To Add Driwe project',2,'[]',10,1,'2025-05-20 14:16:08.923488'),
 (18,'2','To Add Driwe project',2,'[]',10,1,'2025-05-20 14:18:16.102988'),
 (19,'2','To Add Driwe project',2,'[]',10,1,'2025-05-20 14:19:14.062448'),
 (20,'2','To Add Driwe project',2,'[]',10,1,'2025-05-20 14:19:51.961333'),
 (21,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:04:07.556072'),
 (22,'5','aSsS',2,'[]',10,1,'2025-05-21 07:04:55.909769'),
 (23,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:07:14.664326'),
 (24,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:08:25.183975'),
 (25,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:08:51.320277'),
 (26,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:10:15.038655'),
 (27,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:10:40.134192'),
 (28,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:26:58.104060'),
 (29,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:37:49.789185'),
 (30,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:43:09.048836'),
 (31,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:50:23.809919'),
 (32,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:52:14.890607'),
 (33,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 07:59:25.845830'),
 (34,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 10:08:22.716608'),
 (35,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 10:09:53.392924'),
 (36,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 10:10:27.109590'),
 (37,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 10:11:02.308363'),
 (38,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 10:12:23.114908'),
 (39,'2','To Add Driwe project',2,'[]',10,1,'2025-05-21 10:25:00.957618'),
 (40,'5','aSsS',3,'',10,1,'2025-05-21 10:28:08.322778'),
 (41,'4','sss',3,'',10,1,'2025-05-21 10:28:08.632175'),
 (42,'3','This',3,'',10,1,'2025-05-21 10:28:08.847722'),
 (43,'2','To Add Driwe project',3,'',10,1,'2025-05-21 10:28:09.107352'),
 (44,'1','To Create Crud',3,'',10,1,'2025-05-21 10:28:09.349124'),
 (45,'1','Driwe',2,'[{"changed": {"fields": ["Name"]}}]',9,1,'2025-05-21 10:28:30.883098'),
 (46,'6','Create Admin Panel',1,'[{"added": {}}]',10,1,'2025-05-21 10:30:27.302459'),
 (47,'6','Create Admin Panel',2,'[]',10,1,'2025-05-21 10:33:09.082709'),
 (48,'6','Create Admin Panel',2,'[]',10,1,'2025-05-21 10:33:44.377902'),
 (49,'2','oshin.kawale@profcyma.com',2,'[{"changed": {"fields": ["First name", "Last name", "Email address"]}}]',4,1,'2025-05-21 10:59:50.015939'),
 (50,'6','Create Admin Panel',2,'[]',10,1,'2025-05-21 11:01:52.099383'),
 (51,'6','Create Admin Panel',2,'[]',10,1,'2025-05-21 11:03:57.162288'),
 (52,'6','Create Admin Panel',2,'[{"changed": {"fields": ["Description"]}}]',10,1,'2025-05-21 11:47:36.204356'),
 (53,'3','sanket.thawari@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-21 12:15:39.009833'),
 (54,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "User permissions"]}}]',4,1,'2025-05-21 12:17:42.049868'),
 (55,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["Staff status"]}}]',4,1,'2025-05-21 12:22:42.478714'),
 (56,'2','oshin.kawale@profcyma.com',2,'[{"changed": {"fields": ["password"]}}]',4,1,'2025-05-21 12:24:15.894867'),
 (57,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["password"]}}]',4,1,'2025-05-21 12:27:51.627772'),
 (58,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["Superuser status"]}}]',4,1,'2025-05-21 12:28:02.339663'),
 (59,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["Superuser status"]}}]',4,3,'2025-05-21 12:28:46.837465'),
 (60,'7','New Task recieved',1,'[{"added": {}}]',10,3,'2025-05-21 12:32:58.033059'),
 (61,'7','New Task recieved',2,'[]',10,3,'2025-05-21 12:33:57.377043'),
 (62,'6','Create Admin Panel',2,'[]',10,3,'2025-05-21 12:34:18.627979'),
 (63,'1','Team Leader',1,'[{"added": {}}]',3,1,'2025-05-21 12:43:31.803544'),
 (64,'2','Team Member',1,'[{"added": {}}]',3,1,'2025-05-21 12:43:56.209062'),
 (65,'2','Team Member',2,'[{"changed": {"fields": ["Permissions"]}}]',3,1,'2025-05-21 12:44:19.981878'),
 (66,'4','ankur.jain@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-21 12:49:30.958691'),
 (67,'4','ankur.jain@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-21 12:50:03.388547'),
 (68,'6','Create Admin Panel',2,'[{"changed": {"fields": ["Assigned to", "Assigned by"]}}]',10,3,'2025-05-21 12:51:32.867942'),
 (69,'1','Team Leader',2,'[{"changed": {"fields": ["Permissions"]}}]',3,1,'2025-05-21 12:52:57.444037'),
 (70,'1','Team Leader',2,'[]',3,1,'2025-05-21 12:53:52.372656'),
 (71,'2','Backend',1,'[{"added": {}}]',7,1,'2025-05-21 12:54:29.518162'),
 (72,'2','sanket.thawari@profcyma.in - Backend',1,'[{"added": {}}]',8,1,'2025-05-21 12:54:38.945499'),
 (73,'3','ankur.jain@profcyma.in - Backend',1,'[{"added": {}}]',8,1,'2025-05-21 12:54:49.071676'),
 (74,'3','sanket.thawari@profcyma.in',2,'[]',4,1,'2025-05-21 12:56:00.441868'),
 (75,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["Groups"]}}]',4,1,'2025-05-21 12:56:22.497995'),
 (76,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["User permissions"]}}]',4,1,'2025-05-21 12:56:41.240265'),
 (77,'3','sanket.thawari@profcyma.in',2,'[]',4,1,'2025-05-21 12:56:56.664737'),
 (78,'1','Create Admin Panel - 2025-05-21 - 60%',1,'[{"added": {}}]',14,3,'2025-05-21 13:38:01.820492'),
 (79,'2','Team Member',2,'[{"changed": {"fields": ["Permissions"]}}]',3,1,'2025-05-21 14:06:20.933997'),
 (80,'4','ankur.jain@profcyma.in',2,'[]',4,1,'2025-05-21 14:06:34.729011'),
 (81,'7','New Task recieved',2,'[{"changed": {"fields": ["Assigned to"]}}]',10,1,'2025-05-21 14:06:49.860569'),
 (82,'6','Create Admin Panel',2,'[]',10,1,'2025-05-21 14:06:59.404808'),
 (83,'4','ankur.jain@profcyma.in',2,'[{"changed": {"fields": ["Email address"]}}]',4,1,'2025-05-21 14:07:29.196094'),
 (84,'7','New Task recieved',2,'[]',10,1,'2025-05-21 14:07:47.576663'),
 (85,'8','New Ui',1,'[{"added": {}}]',10,3,'2025-05-21 14:09:21.074581'),
 (86,'8','New Ui',2,'[]',10,3,'2025-05-21 14:17:43.892596'),
 (87,'8','New Ui',2,'[]',10,3,'2025-05-21 14:18:26.427687'),
 (88,'3','sanket.thawari@profcyma.in',2,'[]',4,1,'2025-05-22 06:40:51.988406'),
 (89,'1','Team Leader',2,'[]',3,1,'2025-05-22 06:41:50.536858'),
 (90,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["User permissions"]}}]',4,1,'2025-05-22 06:53:43.210730'),
 (91,'4','oshin.kawale@profcyma.com - Backend',1,'[{"added": {}}]',8,1,'2025-05-22 06:56:39.007406'),
 (92,'2','oshin.kawale@profcyma.com',2,'[{"changed": {"fields": ["Staff status"]}}]',4,1,'2025-05-22 06:56:59.815047'),
 (93,'1','Team Leader',2,'[{"changed": {"fields": ["Permissions"]}}]',3,1,'2025-05-22 06:57:38.597286'),
 (94,'1','Team Leader',2,'[]',3,1,'2025-05-22 06:58:15.761274'),
 (95,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["User permissions"]}}]',4,1,'2025-05-22 06:58:50.439600'),
 (96,'2','oshin.kawale@profcyma.com',2,'[]',4,1,'2025-05-22 07:03:26.867426'),
 (97,'2','oshin.kawale@profcyma.com',2,'[{"changed": {"fields": ["Groups"]}}]',4,1,'2025-05-22 07:03:38.526372'),
 (98,'3','sanket.thawari@profcyma.in',2,'[{"changed": {"fields": ["User permissions"]}}]',4,1,'2025-05-22 07:11:31.136259'),
 (99,'1','Team Leader',2,'[]',3,1,'2025-05-22 07:56:14.155156'),
 (100,'1','Team Leader',2,'[]',3,1,'2025-05-22 07:56:14.470266'),
 (101,'1','Team Leader',2,'[]',3,1,'2025-05-22 07:56:14.766604'),
 (102,'1','Team Leader',2,'[]',3,1,'2025-05-22 07:56:15.064526'),
 (103,'1','Team Leader',2,'[]',3,1,'2025-05-22 07:56:15.479170'),
 (104,'1','Team Leader',2,'[]',3,1,'2025-05-22 07:56:22.861909'),
 (105,'1','Create Admin Panel - in_progress (0%)',1,'[{"added": {}}]',15,4,'2025-05-22 11:09:33.527519'),
 (106,'1','Create Admin Panel - in_progress (0%)',2,'[]',15,4,'2025-05-22 11:25:07.825420'),
 (107,'1','Create Admin Panel - review (0%)',2,'[{"changed": {"fields": ["Status"]}}]',15,4,'2025-05-22 11:25:12.626194'),
 (108,'1','Create Admin Panel - in_progress (0%)',2,'[{"changed": {"fields": ["Status"]}}]',15,4,'2025-05-22 11:34:41.336677'),
 (109,'1','Create Admin Panel - in_progress (60%)',2,'[{"changed": {"fields": ["Progress percent"]}}]',15,3,'2025-05-22 12:05:27.968046'),
 (110,'1','Create Admin Panel - completed (60%)',2,'[{"changed": {"fields": ["Status"]}}]',15,4,'2025-05-22 12:06:22.571877'),
 (111,'2','Team Member',2,'[{"changed": {"fields": ["Permissions"]}}]',3,1,'2025-05-22 13:02:35.639588'),
 (112,'1','oshin.kawale@profcyma.com - Ui/Ux',3,'',8,1,'2025-05-23 09:46:26.440017'),
 (113,'5','kalyani.raghatate@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-23 11:55:49.988022'),
 (114,'5','kalyani.raghatate@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-23 11:56:23.071495'),
 (115,'6','aditya.jagtap@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-23 11:57:08.430490'),
 (116,'6','aditya.jagtap@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-23 11:57:48.505784'),
 (117,'3','Frontend Development',1,'[{"added": {}}]',7,1,'2025-05-23 11:58:08.765410'),
 (118,'5','aditya.jagtap@profcyma.in - Frontend Development',1,'[{"added": {}}]',8,1,'2025-05-23 12:04:58.312211'),
 (119,'6','kalyani.raghatate@profcyma.in - Backend',1,'[{"added": {}}]',8,1,'2025-05-23 12:05:14.175274'),
 (120,'4','Mobile App Development',1,'[{"added": {}}]',7,1,'2025-05-23 12:08:56.670089'),
 (121,'2','Backend Development',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-05-26 11:57:23.846912'),
 (122,'1','Ui/Ux Designer',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-05-26 11:57:32.672555'),
 (123,'1','Driwe',3,'',9,1,'2025-05-27 11:43:54.129349'),
 (124,'5','QA Team',1,'[{"added": {}}]',7,1,'2025-05-27 11:45:03.017153'),
 (125,'7','paresh.markad@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-27 11:45:54.256829'),
 (126,'7','paresh.markad@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-27 11:46:18.229380'),
 (127,'8','pratiksha.pethe@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:13:50.666630'),
 (128,'8','pratiksha.pethe@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:14:12.209030'),
 (129,'9','sonu.buradkar@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:15:14.505605'),
 (130,'9','sonu.buradkar@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:15:42.577536'),
 (131,'10','prathmesh.raut@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:16:46.543394'),
 (132,'10','prathmesh.raut@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:17:02.321742'),
 (133,'11','kirankumar.falmari@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:18:00.250629'),
 (134,'11','kirankumar.falmari@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:19:37.530967'),
 (135,'12','yuktesh.jadhav@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:20:27.341163'),
 (136,'12','yuktesh.jadhav@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:20:47.428848'),
 (137,'13','abhishek.thakur@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:21:44.536311'),
 (138,'13','abhishek.thakur@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:22:00.443754'),
 (139,'14','omkar.nilakhe@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 07:23:48.696251'),
 (140,'14','omkar.nilakhe@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 07:24:17.127843'),
 (141,'15','tejas.langote@profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 08:58:26.871618'),
 (142,'15','tejas.langote@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 08:58:55.657228'),
 (143,'16','poonam.chawaria.profcyma.in',1,'[{"added": {}}]',4,1,'2025-05-28 09:00:01.179465'),
 (144,'16','poonam.chawariya@profcyma.in',2,'[{"changed": {"fields": ["Username", "First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-05-28 09:01:15.742599'),
 (145,'2','I Cab Contrive',1,'[{"added": {}}]',9,1,'2025-05-30 09:38:34.584867'),
 (146,'3','Espoir Tech',1,'[{"added": {}}]',9,1,'2025-05-30 12:55:30.378697'),
 (147,'4','CG Software',1,'[{"added": {}}]',9,1,'2025-05-30 12:57:13.102994'),
 (148,'5','Stockwave',1,'[{"added": {}}]',9,1,'2025-05-30 13:00:59.145886'),
 (149,'6','Urban Prime',1,'[{"added": {}}]',9,1,'2025-05-30 13:28:46.874239'),
 (150,'5','Stockwave',2,'[{"changed": {"fields": ["Ui percentage", "Backend percentage", "Frontend percentage", "Testing percentage", "Bug solve percentage", "Retest percentage", "Final bug solve percentage", "Production percentage"]}}]',9,1,'2025-06-03 07:41:29.393048'),
 (151,'5','Stockwave',2,'[]',9,1,'2025-06-03 09:27:33.782061'),
 (152,'7','Harvestera',1,'[{"added": {}}]',9,1,'2025-06-03 10:21:35.735058'),
 (153,'7','Harvestera',2,'[]',9,1,'2025-06-03 11:10:12.121105'),
 (154,'7','Harvestera',2,'[]',9,1,'2025-06-03 11:11:12.298741'),
 (155,'7','Harvestera',2,'[]',9,1,'2025-06-03 11:16:09.189683'),
 (156,'8','Vedant Agro',1,'[{"added": {}}]',9,1,'2025-06-03 11:30:40.277298'),
 (157,'9','Star Broadcast',1,'[{"added": {}}]',9,1,'2025-06-03 12:36:49.500956'),
 (158,'10','Aayas Engineering',1,'[{"added": {}}]',9,1,'2025-06-03 12:40:35.110546'),
 (159,'11','Navsiddhi',1,'[{"added": {}}]',9,1,'2025-06-04 06:56:37.917932'),
 (160,'12','Groscido',1,'[{"added": {}}]',9,1,'2025-06-04 07:07:28.856550'),
 (161,'13','CropyKo',1,'[{"added": {}}]',9,1,'2025-06-04 07:18:13.947269'),
 (162,'14','Lovmance',1,'[{"added": {}}]',9,1,'2025-06-04 07:26:26.091287'),
 (163,'15','Dhanubook',1,'[{"added": {}}]',9,1,'2025-06-04 07:34:58.844156'),
 (164,'15','Dhanubook',2,'[]',9,1,'2025-06-04 07:41:03.525360'),
 (165,'1','Guddu',1,'[{"added": {}}]',16,1,'2025-06-04 12:10:23.665396'),
 (166,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',1,'[{"added": {}}]',17,1,'2025-06-04 12:14:39.695727'),
 (167,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:17:20.829140'),
 (168,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:17:53.349758'),
 (169,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:19:05.874732'),
 (170,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:46:06.664963'),
 (171,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:48:19.202768'),
 (172,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:48:28.685778'),
 (173,'1','Guddu',2,'[{"changed": {"fields": ["Phone number"]}}]',16,1,'2025-06-04 12:51:37.916240'),
 (174,'1','Guddu @ 2025-06-04 12:14:39.692735+00:00',2,'[]',17,1,'2025-06-04 12:51:43.750165'),
 (175,'2','Guddu @ 2025-06-04 13:29:46.367989+00:00',1,'[{"added": {}}]',17,1,'2025-06-04 13:29:46.371441'),
 (176,'2','Guddu @ 2025-06-04 13:29:46.367989+00:00',2,'[]',17,1,'2025-06-04 13:39:09.137746'),
 (177,'2','Guddu @ 2025-06-04 13:29:46.367989+00:00',2,'[]',17,1,'2025-06-04 13:46:55.243836'),
 (178,'2','Guddu @ 2025-06-04 13:29:46.367989+00:00',2,'[]',17,1,'2025-06-04 13:48:20.032883'),
 (179,'3','Guddu @ 2025-06-04 13:49:04.903111+00:00',1,'[{"added": {}}]',17,1,'2025-06-04 13:49:04.905120'),
 (180,'4','Guddu @ 2025-06-04 14:05:38.884483+00:00',1,'[{"added": {}}]',17,1,'2025-06-04 14:05:38.887491'),
 (181,'3','Guddu @ 2025-06-04 13:49:04.903111+00:00',2,'[]',17,1,'2025-06-04 14:11:54.193563'),
 (182,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',1,'[{"added": {}}]',17,1,'2025-06-04 14:12:25.370730'),
 (183,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',2,'[]',17,1,'2025-06-04 14:14:43.819764'),
 (184,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',2,'[]',17,1,'2025-06-04 14:20:44.025513'),
 (185,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',2,'[]',17,1,'2025-06-04 14:21:26.045141'),
 (186,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',2,'[]',17,1,'2025-06-04 14:25:05.162157'),
 (187,'3','Guddu @ 2025-06-04 13:49:04.903111+00:00',2,'[]',17,1,'2025-06-04 14:25:16.963139'),
 (188,'3','Guddu @ 2025-06-04 13:49:04.903111+00:00',2,'[]',17,1,'2025-06-04 14:29:20.933756'),
 (189,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',2,'[]',17,1,'2025-06-04 14:49:34.120163'),
 (190,'5','Guddu @ 2025-06-04 14:12:25.368762+00:00',2,'[]',17,1,'2025-06-05 10:09:44.571299'),
 (191,'1','user1: Hello, this is a test message!',2,'[]',18,1,'2025-06-05 11:31:18.287468'),
 (192,'2','user1: a',1,'[{"added": {}}]',18,1,'2025-06-05 13:00:42.808734'),
 (193,'16','Aarogya Food',1,'[{"added": {}}]',9,1,'2025-06-18 10:55:52.634367'),
 (194,'17','Om Tapovan',1,'[{"added": {}}]',9,1,'2025-06-18 11:01:22.561855'),
 (195,'18','Star555',1,'[{"added": {}}]',9,1,'2025-06-18 11:03:38.151576'),
 (196,'19','Gravity Drive',1,'[{"added": {}}]',9,1,'2025-06-18 11:07:14.943997'),
 (197,'20','Swadpurti',1,'[{"added": {}}]',9,1,'2025-06-18 11:08:37.020822'),
 (198,'21','Bapat Optics',1,'[{"added": {}}]',9,1,'2025-06-18 11:10:23.825919'),
 (199,'22','BMW',1,'[{"added": {}}]',9,1,'2025-06-18 11:12:02.297565'),
 (200,'23','My Wealth 2nd Phase',1,'[{"added": {}}]',9,1,'2025-06-18 11:13:45.433674'),
 (201,'24','Absar Money 2nd Phase',1,'[{"added": {}}]',9,1,'2025-06-18 11:15:21.630139'),
 (202,'25','Game Katta 2nd phase',1,'[{"added": {}}]',9,1,'2025-06-18 11:16:27.375817'),
 (203,'25','Game Katta 2nd phase',2,'[{"changed": {"fields": ["Ui percentage", "Backend percentage", "Mobile app percentage"]}}]',9,1,'2025-06-18 11:16:48.188831'),
 (204,'1','Om Tapovan - project_documents/Om_Tapovan_Event_WBS__APP.docx',1,'[{"added": {}}]',19,1,'2025-06-18 11:40:27.115053'),
 (205,'15','Dhanubook',2,'[{"changed": {"fields": ["Status"]}}]',9,1,'2025-06-30 06:57:20.699769'),
 (206,'26','Coinzkart 2nd Phase Luxury',1,'[{"added": {}}]',9,1,'2025-06-30 07:28:25.613217'),
 (207,'27','Netpurti',1,'[{"added": {}}]',9,1,'2025-06-30 07:29:01.694781'),
 (208,'28','Boomerbuckz',1,'[{"added": {}}]',9,1,'2025-06-30 07:30:04.098541'),
 (209,'29','The Moon',1,'[{"added": {}}]',9,1,'2025-06-30 07:31:11.881170'),
 (210,'30','Local Mandai',1,'[{"added": {}}]',9,1,'2025-06-30 07:32:22.970293'),
 (211,'31','Shubharambh',1,'[{"added": {}}]',9,1,'2025-06-30 07:33:16.754343'),
 (212,'32','IT Pulse',1,'[{"added": {}}]',9,1,'2025-06-30 07:33:59.923255'),
 (213,'33','Bhingari',1,'[{"added": {}}]',9,1,'2025-06-30 07:34:55.020327'),
 (214,'34','JGM',1,'[{"added": {}}]',9,1,'2025-06-30 07:42:01.016195'),
 (215,'35','Real Estate',1,'[{"added": {}}]',9,1,'2025-06-30 07:42:40.833793'),
 (216,'36','Printout Media',1,'[{"added": {}}]',9,1,'2025-06-30 07:43:19.128745'),
 (217,'37','Icon Cabs',1,'[{"added": {}}]',9,1,'2025-06-30 07:49:30.317172'),
 (218,'38','Pyros',1,'[{"added": {}}]',9,1,'2025-06-30 07:50:18.681250'),
 (219,'39','Flick and Shoot',1,'[{"added": {}}]',9,1,'2025-06-30 07:50:58.529144'),
 (220,'40','Painganga',1,'[{"added": {}}]',9,1,'2025-06-30 07:51:47.914968'),
 (221,'41','Bailgada',1,'[{"added": {}}]',9,1,'2025-07-01 06:57:36.519051'),
 (222,'41','Bailgada',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:06:35.338358'),
 (223,'40','Painganga',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:08:40.432350'),
 (224,'39','Flick and Shoot',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:09:09.039486'),
 (225,'38','Pyros',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:24:57.629246'),
 (226,'37','Icon Cabs',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 07:26:09.168649'),
 (227,'40','Painganga',2,'[{"changed": {"fields": ["Status"]}}]',9,1,'2025-07-01 07:26:17.628681'),
 (228,'36','Printout Media',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:26:44.583945'),
 (229,'35','Real Estate',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 07:27:32.341391'),
 (230,'34','JGM',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:28:24.032911'),
 (231,'33','Bhingari',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:28:46.091373'),
 (232,'32','IT Pulse',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 07:29:12.631610'),
 (233,'31','Shubharambh',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 07:29:58.313756'),
 (234,'30','Local Mandai',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:31:04.314312'),
 (235,'29','The Moon',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:32:30.879444'),
 (236,'28','Boomerbuckz',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:34:27.038408'),
 (237,'27','Netpurti',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 07:34:48.401516'),
 (238,'26','Coinzkart 2nd Phase Luxury',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 07:35:45.633950'),
 (239,'25','Game Katta 2nd phase',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:50:29.447541'),
 (240,'24','Absar Money 2nd Phase',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:50:52.526635'),
 (241,'23','My Wealth 2nd Phase',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:51:10.013402'),
 (242,'22','One Trade Ai',2,'[{"changed": {"fields": ["Name", "Status details"]}}]',9,1,'2025-07-01 07:54:06.935249'),
 (243,'21','Bapat Optics',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:54:23.648247'),
 (244,'20','Swadpurti',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 07:59:45.544068'),
 (245,'19','Gravity Drive',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 08:00:40.808904'),
 (246,'18','Star555',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 08:40:54.578575'),
 (247,'17','Om Tapovan',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 08:42:52.018833'),
 (248,'16','Aarogya Food',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 08:43:33.588723'),
 (249,'15','Dhanubook',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 08:44:06.479917'),
 (250,'14','Lovmance',2,'[{"changed": {"fields": ["Status details", "Project progress in"]}}]',9,1,'2025-07-01 08:52:27.282571'),
 (251,'13','CropyKo',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 08:52:49.229355'),
 (252,'12','Groscido',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 09:33:03.811291'),
 (253,'11','Navsiddhi',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 09:33:52.154562'),
 (254,'10','Aayas Engineering',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 09:34:22.582835'),
 (255,'9','Star Broadcast',2,'[{"changed": {"fields": ["Status", "Status details"]}}]',9,1,'2025-07-01 09:35:08.374122'),
 (256,'8','Vedant Agro',2,'[{"changed": {"fields": ["Status details", "Project progress in"]}}]',9,1,'2025-07-01 09:37:04.101139'),
 (257,'7','Harvestera',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-01 09:37:46.057717'),
 (258,'6','Urban Prime',2,'[{"changed": {"fields": ["Status details", "Backend percentage", "Mobile app percentage", "Testing percentage"]}}]',9,1,'2025-07-01 09:38:49.115283'),
 (259,'5','Stockwave',2,'[{"changed": {"fields": ["Status details", "Frontend percentage"]}}]',9,1,'2025-07-01 09:40:14.688638'),
 (260,'4','CG Software',2,'[{"changed": {"fields": ["Status details", "Frontend percentage", "Backend percentage", "Testing percentage"]}}]',9,1,'2025-07-01 09:41:40.348033'),
 (261,'3','Espoir Tech',2,'[{"changed": {"fields": ["Status details", "Frontend percentage", "Backend percentage", "Production percentage"]}}]',9,1,'2025-07-01 09:43:33.545050'),
 (262,'3','Espoir Tech',2,'[{"changed": {"fields": ["Start date"]}}]',9,1,'2025-07-01 09:43:57.817188'),
 (263,'2','I Cab Contrive',2,'[{"changed": {"fields": ["Status details", "Ui percentage", "Frontend percentage", "Backend percentage", "Mobile app percentage", "Testing percentage"]}}]',9,1,'2025-07-01 09:45:43.774810'),
 (264,'1','New Task',1,'[{"added": {}}]',10,1,'2025-07-01 11:09:12.138390'),
 (265,'1','Feedback for Stockwave on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 1"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 1"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 1"}}]',20,1,'2025-07-03 06:22:05.930680'),
 (266,'2','Feedback for Stockwave on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 2"}}]',20,1,'2025-07-03 06:42:08.257909'),
 (267,'2','Feedback for Stockwave on 2025-07-03',3,'',20,1,'2025-07-03 06:43:28.734200'),
 (268,'1','Feedback for Stockwave on 2025-07-03',3,'',20,1,'2025-07-03 06:43:37.550305'),
 (269,'3','Feedback for CG Software on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 3"}}]',20,1,'2025-07-03 06:44:15.784747'),
 (270,'3','Feedback for CG Software on 2025-07-03',2,'[]',20,1,'2025-07-03 06:45:25.210753'),
 (271,'4','Feedback for I Cab Contrive on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 4"}}]',20,1,'2025-07-03 06:45:54.058985'),
 (272,'5','Feedback for I Cab Contrive on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 5"}}]',20,1,'2025-07-03 06:48:27.776424'),
 (273,'5','Feedback for I Cab Contrive on 2025-07-03',2,'[{"changed": {"fields": ["Users to notify"]}}, {"added": {"name": "project feedback image", "object": "Image for feedback 5"}}]',20,1,'2025-07-03 06:49:48.167070'),
 (274,'6','Feedback for Vedant Agro on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 6"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 6"}}]',20,1,'2025-07-03 06:50:52.817890'),
 (275,'7','Feedback for CG Software on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 7"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 7"}}]',20,1,'2025-07-03 07:27:59.870302'),
 (276,'17','guddu.kumar@profcyma.in',1,'[{"added": {}}]',4,1,'2025-07-03 08:43:36.457942'),
 (277,'17','guddu.kumar@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Superuser status"]}}]',4,1,'2025-07-03 08:44:17.656108'),
 (278,'8','Feedback for Om Tapovan on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 8"}}]',20,1,'2025-07-03 09:13:30.373851'),
 (279,'17','guddu.kumar@profcyma.com',2,'[{"changed": {"fields": ["Username", "Email address"]}}]',4,1,'2025-07-03 09:14:26.840813'),
 (280,'8','Feedback for Om Tapovan on 2025-07-03',2,'[{"added": {"name": "project feedback image", "object": "Image for feedback 8"}}]',20,1,'2025-07-03 09:15:31.333489'),
 (281,'1','Ui/Ux Designer - Urban Prime',1,'[{"added": {}}]',22,1,'2025-07-03 09:48:33.027225'),
 (282,'9','Feedback for I Cab Contrive on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 9"}}]',20,1,'2025-07-03 10:18:32.425321'),
 (283,'9','Feedback for I Cab Contrive on 2025-07-03',2,'[]',20,1,'2025-07-03 10:22:37.729565'),
 (284,'2','Ui/Ux Designer - Urban Prime',1,'[{"added": {}}]',22,1,'2025-07-03 11:31:19.920554'),
 (285,'4','Mobile App Design',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-07-03 11:34:41.314908'),
 (286,'6','Mobile App Integration',1,'[{"added": {}}]',7,1,'2025-07-03 11:34:58.469391'),
 (287,'2','Backend Setup Admin Panel',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-07-03 11:36:27.324053'),
 (288,'7','Integartion with website',1,'[{"added": {}}]',7,1,'2025-07-03 11:36:49.376012'),
 (289,'7','Integration with website',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-07-03 11:36:59.226771'),
 (290,'5','Primary Testing',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-07-03 11:37:21.383108'),
 (291,'8','Recurssive Testing',1,'[{"added": {}}]',7,1,'2025-07-03 11:37:31.559954'),
 (292,'7','Integration with website (Backend)',2,'[{"changed": {"fields": ["Name"]}}]',7,1,'2025-07-03 11:37:55.516953'),
 (293,'2','Ui/Ux Designer - Urban Prime',3,'',22,1,'2025-07-03 11:54:34.808706'),
 (294,'1','Ui/Ux Designer - Urban Prime',3,'',22,1,'2025-07-03 11:54:34.808706'),
 (295,'36','Printout Media',2,'[{"changed": {"fields": ["Status"]}}]',9,1,'2025-07-03 11:55:30.846926'),
 (296,'42','Ayansh Internation',1,'[{"added": {}}]',9,1,'2025-07-03 12:04:03.040625'),
 (297,'3','Ui/Ux Designer - Ayansh Internation',1,'[{"added": {}}]',22,1,'2025-07-03 12:05:48.090010'),
 (298,'4','Frontend Development - Ayansh Internation',1,'[{"added": {}}]',22,1,'2025-07-03 12:07:11.384919'),
 (299,'43','Urban Build',1,'[{"added": {}}]',9,1,'2025-07-03 12:59:36.184122'),
 (300,'20','Swadpurti',2,'[{"changed": {"fields": ["Status"]}}]',9,1,'2025-07-03 13:26:09.343057'),
 (301,'13','CropyKo',3,'',9,1,'2025-07-03 13:26:38.931012'),
 (302,'18','sakshi.gawande@profcyma.in',1,'[{"added": {}}]',4,1,'2025-07-04 04:39:46.924051'),
 (303,'10','Feedback for Boomerbuckz on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 10"}}]',20,1,'2025-07-04 04:40:17.560457'),
 (304,'19','prajwal.narkhede@profcyma.in',1,'[{"added": {}}]',4,1,'2025-07-04 04:43:48.381988'),
 (305,'11','Feedback for The Moon on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 11"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 11"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 11"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 11"}}]',20,1,'2025-07-04 04:47:28.532400'),
 (306,'11','Feedback for The Moon on 2025-07-04',2,'[]',20,1,'2025-07-04 04:51:17.892640'),
 (307,'11','Feedback for The Moon on 2025-07-04',2,'[{"changed": {"fields": ["Users to notify"]}}]',20,1,'2025-07-04 04:51:55.485418'),
 (308,'11','Feedback for The Moon on 2025-07-04',2,'[{"changed": {"fields": ["Users to notify"]}}]',20,1,'2025-07-04 04:52:58.675836'),
 (309,'11','Feedback for The Moon on 2025-07-04',2,'[{"changed": {"fields": ["Users to notify"]}}]',20,1,'2025-07-04 04:54:09.209354'),
 (310,'19','prajwal.narkhede@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Groups"]}}]',4,1,'2025-07-04 04:56:07.898605'),
 (311,'18','sakshi.gawande@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Groups"]}}]',4,1,'2025-07-04 04:56:30.733794'),
 (312,'19','prajwal.narkhede@profcyma.in',2,'[{"changed": {"fields": ["Staff status"]}}]',4,1,'2025-07-04 04:56:43.513813'),
 (313,'18','sakshi.gawande@profcyma.in',2,'[{"changed": {"fields": ["Staff status"]}}]',4,1,'2025-07-04 04:56:51.744222'),
 (314,'11','Feedback for The Moon on 2025-07-04',2,'[]',20,1,'2025-07-04 04:57:09.362668'),
 (315,'5','Ui/Ux Designer - Urban Build',1,'[{"added": {}}]',22,1,'2025-07-04 05:27:17.251243'),
 (316,'44','Reachout Media',1,'[{"added": {}}]',9,1,'2025-07-04 05:39:22.392171'),
 (317,'45','Sahyadri Transport 2nd phase',1,'[{"added": {}}]',9,1,'2025-07-04 05:55:36.114263'),
 (318,'12','Feedback for Sahyadri Transport 2nd phase on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 12"}}]',20,1,'2025-07-04 05:56:51.637524'),
 (319,'10','Feedback for Boomerbuckz on 2025-07-04',2,'[{"changed": {"fields": ["Users to notify"]}}, {"added": {"name": "project feedback image", "object": "Image for feedback 10"}}]',20,1,'2025-07-04 06:46:50.389348'),
 (320,'13','Feedback for Reachout Media on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 13"}}]',20,1,'2025-07-04 06:58:25.716514'),
 (321,'3','Feedback for CG Software on 2025-07-03',2,'[]',20,1,'2025-07-04 07:42:51.903017'),
 (322,'5','Feedback for I Cab Contrive on 2025-07-03',2,'[]',20,1,'2025-07-04 07:43:42.259321'),
 (323,'3','Feedback for CG Software on 2025-07-03',2,'[]',20,1,'2025-07-04 07:44:17.141081'),
 (324,'14','Feedback for I Cab Contrive on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 14"}}]',20,1,'2025-07-04 07:46:03.244058'),
 (325,'14','Feedback for I Cab Contrive on 2025-07-04',3,'',20,1,'2025-07-04 07:48:37.437769'),
 (326,'15','Feedback for I Cab Contrive on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 15"}}]',20,1,'2025-07-04 07:49:03.154444'),
 (327,'15','Feedback for I Cab Contrive on 2025-07-04',3,'',20,1,'2025-07-04 07:51:40.530223'),
 (328,'16','Feedback for I Cab Contrive on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 16"}}]',20,1,'2025-07-04 07:52:58.821961'),
 (329,'16','Feedback for I Cab Contrive on 2025-07-04',3,'',20,1,'2025-07-04 07:53:21.321100'),
 (330,'17','Feedback for Espoir Tech on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 17"}}]',20,1,'2025-07-04 07:54:14.389660'),
 (331,'17','Feedback for Espoir Tech on 2025-07-04',3,'',20,1,'2025-07-04 07:54:58.109209'),
 (332,'18','Feedback for Espoir Tech on 2025-07-03',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 18"}}]',20,1,'2025-07-04 07:59:43.952333'),
 (333,'19','Feedback for Bapat Optics on 2025-07-04',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 19"}}]',20,1,'2025-07-04 09:19:58.016228'),
 (334,'19','Feedback for Bapat Optics on 2025-07-04',2,'[{"added": {"name": "project feedback image", "object": "Image for feedback 19"}}]',20,1,'2025-07-04 09:41:50.582944'),
 (335,'46','Nagma',1,'[{"added": {}}]',9,1,'2025-07-04 13:54:19.033583'),
 (336,'20','Feedback for The Moon on 2025-07-07',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 20"}}]',20,1,'2025-07-07 04:43:55.464811'),
 (337,'21','Feedback for Reachout Media on 2025-07-07',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 21"}}]',20,1,'2025-07-07 08:47:55.988741'),
 (338,'47','Dhagaa',1,'[{"added": {}}]',9,1,'2025-07-07 09:54:34.351815'),
 (339,'22','Feedback for Dhagaa on 2025-07-07',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 22"}}]',20,1,'2025-07-07 09:56:28.636443'),
 (340,'23','Feedback for CG Software on 2025-07-07',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 23"}}]',20,1,'2025-07-07 10:30:50.883252'),
 (341,'48','A2Z',1,'[{"added": {}}]',9,1,'2025-07-08 04:56:08.684092'),
 (342,'20','yash.deshmukh@profcyma.in',1,'[{"added": {}}]',4,1,'2025-07-08 04:57:38.705296'),
 (343,'20','yash.deshmukh@profcyma.in',2,'[{"changed": {"fields": ["First name", "Last name", "Email address", "Staff status", "Groups"]}}]',4,1,'2025-07-08 04:59:29.881306'),
 (344,'24','Feedback for A2Z on 2025-07-08',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 24"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 24"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 24"}}, {"added": {"name": "project feedback image", "object": "Image for feedback 24"}}]',20,1,'2025-07-08 05:01:24.667102'),
 (345,'11','Navsiddhi',2,'[{"changed": {"fields": ["Project progress in"]}}]',9,1,'2025-07-08 06:41:06.084491'),
 (346,'45','Sahyadri Transport 2nd phase',2,'[{"changed": {"fields": ["Status"]}}]',9,1,'2025-07-08 06:42:16.928917'),
 (347,'44','Reachout Media',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-08 06:44:40.729855'),
 (348,'43','Urban Build',2,'[]',9,1,'2025-07-08 07:10:55.364481'),
 (349,'48','A2Z',2,'[{"changed": {"fields": ["Project progress in"]}}]',9,1,'2025-07-08 07:11:49.109660'),
 (350,'45','Sahyadri Transport 2nd phase',2,'[{"changed": {"fields": ["Project progress in"]}}]',9,1,'2025-07-08 07:12:28.551152'),
 (351,'39','Flick and Shoot',2,'[{"changed": {"fields": ["Status"]}}]',9,1,'2025-07-08 07:12:59.670660'),
 (352,'40','Painganga',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-08 07:20:22.170669'),
 (353,'44','Reachout Media',2,'[]',9,1,'2025-07-08 07:20:46.434339'),
 (354,'43','Urban Build',2,'[]',9,1,'2025-07-08 07:20:57.368356'),
 (355,'42','Ayansh Internation',2,'[]',9,1,'2025-07-08 07:21:25.106970'),
 (356,'41','Bailgada',2,'[]',9,1,'2025-07-08 07:21:42.656360'),
 (357,'34','JGM',2,'[{"changed": {"fields": ["Status details"]}}]',9,1,'2025-07-08 07:23:09.722261'),
 (358,'19','Gravity Drive',2,'[{"changed": {"fields": ["Status", "Status details", "Project progress in"]}}]',9,1,'2025-07-08 07:41:45.882448'),
 (359,'6','Ui/Ux Designer - Gravity Drive',1,'[{"added": {}}]',22,1,'2025-07-08 07:47:09.712429'),
 (360,'25','Feedback for Reachout Media on 2025-07-08',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 25"}}]',20,1,'2025-07-08 07:50:52.822524'),
 (361,'26','Feedback for Espoir Tech on 2025-07-08',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 26"}}]',20,1,'2025-07-08 08:55:45.184330'),
 (362,'2','I Cab Contrive - project_documents/CONTRIVE_TECH_SOLUTIONS_WBS__APP_Agreement_1.docx',1,'[{"added": {}}]',19,1,'2025-07-08 10:56:08.046721'),
 (363,'27','Feedback for Reachout Media on 2025-07-08',1,'[{"added": {}}, {"added": {"name": "project feedback image", "object": "Image for feedback 27"}}]',20,1,'2025-07-08 11:03:51.892046');
INSERT INTO "django_content_type" ("id","app_label","model") VALUES (1,'admin','logentry'),
 (2,'auth','permission'),
 (3,'auth','group'),
 (4,'auth','user'),
 (5,'contenttypes','contenttype'),
 (6,'sessions','session'),
 (7,'teams','team'),
 (8,'teams','teammember'),
 (9,'projects','project'),
 (10,'projects','task'),
 (11,'projects','comment'),
 (12,'projects','attachment'),
 (13,'notifications','notification'),
 (14,'projects','taskstatusupdate'),
 (15,'projects','dailytaskupdate'),
 (16,'messaging','client'),
 (17,'messaging','whatsappmessage'),
 (18,'messaging','twiliochatmessage'),
 (19,'projects','projectdocument'),
 (20,'projects','projectfeedback'),
 (21,'projects','projectfeedbackimage'),
 (22,'projects','teamprogress');
INSERT INTO "django_migrations" ("id","app","name","applied") VALUES (1,'contenttypes','0001_initial','2025-05-19 10:31:19.885740'),
 (2,'auth','0001_initial','2025-05-19 10:31:20.390679'),
 (3,'admin','0001_initial','2025-05-19 10:31:20.822250'),
 (4,'admin','0002_logentry_remove_auto_add','2025-05-19 10:31:21.067927'),
 (5,'admin','0003_logentry_add_action_flag_choices','2025-05-19 10:31:21.468333'),
 (6,'contenttypes','0002_remove_content_type_name','2025-05-19 10:31:21.664655'),
 (7,'auth','0002_alter_permission_name_max_length','2025-05-19 10:31:22.015383'),
 (8,'auth','0003_alter_user_email_max_length','2025-05-19 10:31:22.349254'),
 (9,'auth','0004_alter_user_username_opts','2025-05-19 10:31:22.665361'),
 (10,'auth','0005_alter_user_last_login_null','2025-05-19 10:31:22.888129'),
 (11,'auth','0006_require_contenttypes_0002','2025-05-19 10:31:23.142940'),
 (12,'auth','0007_alter_validators_add_error_messages','2025-05-19 10:31:23.318166'),
 (13,'auth','0008_alter_user_username_max_length','2025-05-19 10:31:23.508308'),
 (14,'auth','0009_alter_user_last_name_max_length','2025-05-19 10:31:23.792584'),
 (15,'auth','0010_alter_group_name_max_length','2025-05-19 10:31:24.056377'),
 (16,'auth','0011_update_proxy_permissions','2025-05-19 10:31:24.391699'),
 (17,'auth','0012_alter_user_first_name_max_length','2025-05-19 10:31:24.626890'),
 (18,'notifications','0001_initial','2025-05-19 10:31:25.094627'),
 (19,'teams','0001_initial','2025-05-19 10:31:25.607212'),
 (20,'projects','0001_initial','2025-05-19 10:31:26.110787'),
 (21,'sessions','0001_initial','2025-05-19 10:31:26.585066'),
 (22,'projects','0002_taskstatusupdate','2025-05-21 12:46:56.799539'),
 (23,'projects','0003_alter_task_assigned_by','2025-05-21 13:35:20.117238'),
 (24,'projects','0004_dailytaskupdate_delete_taskstatusupdate','2025-05-21 14:01:46.430963'),
 (25,'teams','0002_alter_teammember_user','2025-05-23 09:46:38.463893'),
 (26,'projects','0005_project_backend_percentage_and_more','2025-06-03 07:35:50.573629'),
 (27,'projects','0006_project_frontend_percentage','2025-06-03 07:39:21.256376'),
 (28,'projects','0007_rename_team_project_project_progress_in','2025-06-03 07:43:45.727960'),
 (29,'projects','0008_remove_project_frontend_percentage_and_more','2025-06-03 09:27:15.786112'),
 (30,'projects','0009_project_frontend_days_project_frontend_percentage','2025-06-03 10:16:24.679280'),
 (31,'projects','0010_remove_project_description','2025-06-03 11:22:07.578194'),
 (32,'messaging','0001_initial','2025-06-04 11:48:00.070361'),
 (33,'messaging','0002_whatsappmessage_sid_whatsappmessage_status','2025-06-04 12:06:49.739434'),
 (34,'messaging','0003_twiliochatmessage','2025-06-05 10:23:03.563806'),
 (35,'projects','0011_projectfeedback_projectdocument','2025-06-12 15:03:09.362811'),
 (36,'projects','0012_project_project_type','2025-06-30 07:24:10.171421'),
 (37,'projects','0013_remove_comment_task_remove_comment_user_and_more','2025-06-30 11:37:56.677714'),
 (38,'messaging','0002_delete_whatsappmessage','2025-06-30 13:44:41.063253'),
 (39,'notifications','0002_delete_notification','2025-06-30 13:44:41.158224'),
 (40,'projects','0014_projectfeedback_task_dailytaskupdate_comment_and_more','2025-06-30 13:44:41.390766'),
 (41,'projects','0015_project_status_details','2025-07-01 07:02:52.636711'),
 (42,'projects','0016_rename_feedback_projectfeedback_content_and_more','2025-07-03 06:08:25.137841'),
 (43,'projects','0017_remove_projectfeedback_content_and_more','2025-07-03 06:26:27.519887'),
 (44,'projects','0018_teamprogress','2025-07-03 09:34:56.289717'),
 (45,'projects','0019_alter_projectfeedbackimage_image','2025-07-04 06:45:47.444874');
INSERT INTO "django_session" ("session_key","session_data","expire_date") VALUES ('7g0ewmbsws88xnamfsq560rmwcsgsjo1','.eJxVjMsOwiAQRf-FtSE8WhhcuvcbyDADUjU0Ke3K-O_apAvd3nPOfYmI21rj1vMSJxZnMYjT75aQHrntgO_YbrOkua3LlOSuyIN2eZ05Py-H-3dQsddvbX1IQRWTmJnUCAiBkncWwVjNweqsCwwGrMqFIABRcah9ciMWNIXF-wPr0Thz:1uI4gc:j41NcSfDbYV_cKEYT3bLObmK9_Lhl2r_JNvexZbufsE','2025-06-05 12:06:10.050960'),
 ('lnts556wo27j6u8cnb68byd19jpagmv0','.eJxVjDsOwjAQBe_iGll2_MtS0nMGa71e4wBypDipEHeHSCmgfTPzXiLitta4dV7ilMVZaHH63RLSg9sO8h3bbZY0t3WZktwVedAur3Pm5-Vw_w4q9vqtbQ4OAGjQKqkxJVAcnC6eDTMMrIo36KwjQ0VnpuBBZcOKNFnjRgzi_QHbwjfY:1uKcpm:lHjjAHwdEwHcX2c-DqRQITHtbFziVwpNG0qiokQ2XfY','2025-06-12 12:58:10.739018'),
 ('j42iababbcdgz6n2tiq0pase9jv9wfzs','.eJxVjDsOwjAQBe_iGll2_MtS0nMGa71e4wBypDipEHeHSCmgfTPzXiLitta4dV7ilMVZaHH63RLSg9sO8h3bbZY0t3WZktwVedAur3Pm5-Vw_w4q9vqtbQ4OAGjQKqkxJVAcnC6eDTMMrIo36KwjQ0VnpuBBZcOKNFnjRgzi_QHbwjfY:1uKd2W:T5bs682lKCQBOs3O5LClHUEMiP-r7kVizTau93Fp5-I','2025-06-12 13:11:20.633708'),
 ('n3zv2xbdujune4fzopygpau68a422rq3','.eJxVjDsOwjAQBe_iGll2_MtS0nMGa71e4wBypDipEHeHSCmgfTPzXiLitta4dV7ilMVZaHH63RLSg9sO8h3bbZY0t3WZktwVedAur3Pm5-Vw_w4q9vqtbQ4OAGjQKqkxJVAcnC6eDTMMrIo36KwjQ0VnpuBBZcOKNFnjRgzi_QHbwjfY:1uPhaX:w4O36BX8pY7RiXU1TIDvBej2ptMLHIIj5qPPsiBWqfY','2025-06-26 13:03:25.915641'),
 ('cecfd8rwpum0h56m59gs3j1r3amxjm38','.eJxVjEEOwiAQRe_C2pBCoYBL956BDDODVA0kpV0Z765NutDtf-_9l4iwrSVunZc4kzgLJU6_WwJ8cN0B3aHemsRW12VOclfkQbu8NuLn5XD_Dgr08q2RJ5MVsMo5axOc5cSegB0PA6AZg09OgSOn9WSVDWAQCSCrkdDm0Yv3BxFnOPM:1uRtte:aZbNYE711ovhe1Re7k4WzGum_j_ek2WC5Q_FY2lCTBU','2025-07-02 14:36:14.754244'),
 ('b27s76bpis6ybysm7jk7ul6jeclusecn','.eJxVjEEOwiAQRe_C2pBCoYBL956BDDODVA0kpV0Z765NutDtf-_9l4iwrSVunZc4kzgLJU6_WwJ8cN0B3aHemsRW12VOclfkQbu8NuLn5XD_Dgr08q2RJ5MVsMo5axOc5cSegB0PA6AZg09OgSOn9WSVDWAQCSCrkdDm0Yv3BxFnOPM:1uSXWo:Hjju18zlmXmkEs4UT8XHu3ZHoFdt3lN-B2ATGqxDHls','2025-07-04 08:55:18.611442'),
 ('oue2z9gu37zlcrcau1tjz01ufrkinqlr','.eJxVjEEOwiAQRe_C2hAGmAou3fcMZIBBqoYmpV0Z765NutDtf-_9lwi0rTVsnZcwZXERIE6_W6T04LaDfKd2m2Wa27pMUe6KPGiX45z5eT3cv4NKvX5rwuQJgCIkBJ_PmIxRbAtbV7TSDtBq753GbMGwQguQigODmodBoxPvD8nDNng:1uV507:CySybYvoP0LlVLIpgMcDjdH9r7xO4FpOs_HM2MppI0E','2025-07-11 09:04:03.018104'),
 ('eqhdgyw9amzy4od7zvbdvibbth6945ie','.eJxVjEEOwiAQRe_C2hAGmAou3fcMZIBBqoYmpV0Z765NutDtf-_9lwi0rTVsnZcwZXERIE6_W6T04LaDfKd2m2Wa27pMUe6KPGiX45z5eT3cv4NKvX5rwuQJgCIkBJ_PmIxRbAtbV7TSDtBq753GbMGwQguQigODmodBoxPvD8nDNng:1uWYqg:LAsABi6yHSm9GZuKSYu96KQSGjTD80dchbcO1rDtz-o','2025-07-15 11:08:26.157837'),
 ('7ospuldnd2qd1znqdwsedd2fzyo23bwi','.eJxVjEEOwiAQRe_C2pBCCwMu3XsGMgyDVA0kpV0Z765NutDtf-_9lwi4rSVsnZcwJ3EWSpx-t4j04LqDdMd6a5JaXZc5yl2RB-3y2hI_L4f7d1Cwl29NbEabYWQC74HRT2aEBKxRT6yUS0CGfbSKc_aeEmnrXHQ0OCY7KBTvD_CbOFk:1uWymW:mvbGBHWLmToXyDvD5aON_SzYN4FuLVl7HMyslOFKtHU','2025-07-16 14:49:52.975689'),
 ('7in7p21t3xhf2saunfp9v61th9yodau4','.eJxVjEEOwiAQRe_C2pBCCwMu3XsGMgyDVA0kpV0Z765NutDtf-_9lwi4rSVsnZcwJ3EWSpx-t4j04LqDdMd6a5JaXZc5yl2RB-3y2hI_L4f7d1Cwl29NbEabYWQC74HRT2aEBKxRT6yUS0CGfbSKc_aeEmnrXHQ0OCY7KBTvD_CbOFk:1uZ45z:Mws86iNxG62MSaSeE4iK77OXtmxmVQ4LWQ1Gj6O1NLQ','2025-07-22 08:54:35.410926'),
 ('4r2kx8blw9r8joxu80zg47naiimbgpha','.eJxVjEEOwiAQRe_C2pBCCwMu3XsGMgyDVA0kpV0Z765NutDtf-_9lwi4rSVsnZcwJ3EWSpx-t4j04LqDdMd6a5JaXZc5yl2RB-3y2hI_L4f7d1Cwl29NbEabYWQC74HRT2aEBKxRT6yUS0CGfbSKc_aeEmnrXHQ0OCY7KBTvD_CbOFk:1uZ62o:qeTC-OB7_fQKRNcMBUz6gy0--ptTquQDkNZNUHY4V0M','2025-07-22 10:59:26.249640');
INSERT INTO "messaging_client" ("id","name","phone_number","last_contacted") VALUES (1,'Guddu','+918956353504',NULL);
INSERT INTO "messaging_twiliochatmessage" ("id","message_sid","author","body","date_created","channel_sid") VALUES (1,'IM5c0533ec18f643bc8face4a4b63634b7','user1','Hello, this is a test message!','2025-06-05 11:28:14','CHae9d88073987476da63d803d195edb59'),
 (2,'a','user1','a','2025-06-05 13:00:41','CHae9d88073987476da63d803d195edb59');
INSERT INTO "projects_project" ("id","name","start_date","end_date","status","created_at","created_by_id","backend_percentage","bug_solve_percentage","final_bug_solve_percentage","mobile_app_percentage","production_percentage","retest_percentage","testing_percentage","ui_percentage","project_progress_in_id","backend_days","bug_solve_days","final_bug_solve_days","mobile_app_days","production_days","retest_days","testing_days","ui_days","frontend_days","frontend_percentage","project_type","status_details") VALUES (2,'I Cab Contrive','2025-02-17','2025-05-10','on_hold','2025-05-30 09:38:34.529640',1,35.0,0.0,0.0,25.0,0.0,0.0,10.0,20.0,5,21,0,0,15,0,0,6,12,6,10.0,1,'- New Pointers added , working on new pointers'),
 (3,'Espoir Tech','2025-02-03','2025-06-18','in_progress','2025-05-30 12:55:30.327633',1,70.0,0.0,0.0,0.0,10.0,0.0,0.0,0.0,2,69,0,0,0,10,0,0,0,20,20.0,1,'- Project is delayed as per client expectation'),
 (4,'CG Software','2025-04-03','2025-07-04','in_progress','2025-05-30 12:57:13.101997',1,60.0,0.0,0.0,0.0,0.0,0.0,20.0,0.0,2,40,0,0,0,0,0,13,0,13,20.0,1,'- Currently working on client feedback 

- Delayed from expected and client provided deadline'),
 (5,'Stockwave','2025-04-07','2025-05-26','in_progress','2025-05-30 13:00:59.144859',1,35.0,5.0,5.0,0.0,5.0,5.0,10.0,15.0,5,13,2,2,0,2,2,4,5,7,20.0,1,'- Deadline already passed 

- Need to talk with client'),
 (6,'Urban Prime','2025-04-10','2025-06-10','in_progress','2025-05-30 13:28:46.872283',1,50.0,0.0,0.0,25.0,0.0,0.0,25.0,0.0,4,22,0,0,11,0,0,11,0,0,0.0,1,'- Project 99 % completed 

- Yet to deliver'),
 (7,'Harvestera','2025-04-14','2025-07-04','in_progress','2025-06-03 10:21:35.733092',1,30.0,10.0,5.0,0.0,5.0,10.0,10.0,15.0,2,18,6,3,0,3,6,6,9,9,15.0,1,'- Integration is going on 

- Backend Admin is working'),
 (8,'Vedant Agro','2025-05-19','2025-08-08','in_progress','2025-06-03 11:30:40.275330',1,30.0,10.0,10.0,0.0,10.0,10.0,10.0,10.0,2,18,6,6,0,6,6,6,6,6,10.0,1,'- Frontend Done 

- Backend Pending'),
 (9,'Star Broadcast','2025-05-05','2025-06-13','on_hold','2025-06-03 12:36:49.498989',1,30.0,5.0,5.0,0.0,5.0,5.0,20.0,0.0,5,9,2,2,0,2,2,6,0,9,30.0,1,'- Candled due to lack of response from client'),
 (10,'Aayas Engineering','2025-05-21','2025-06-26','in_progress','2025-06-03 12:40:35.108551',1,15.0,5.0,5.0,0.0,5.0,5.0,15.0,25.0,3,4,1,1,0,1,1,4,7,7,25.0,1,'- Oshin working on project'),
 (11,'Navsiddhi','2025-05-12','2025-09-05','in_progress','2025-06-04 06:56:37.912954',1,25.0,3.0,2.0,25.0,2.0,3.0,15.0,20.0,5,21,3,2,21,2,3,13,17,4,5.0,1,'- Backend Development is on going'),
 (12,'Groscido','2025-05-28','2025-09-19','in_progress','2025-06-04 07:07:28.854561',1,15.0,5.0,3.0,20.0,4.0,3.0,15.0,20.0,1,12,4,2,17,3,2,12,17,12,15.0,1,'-Frontend Design done 

- Backend Development Pending'),
 (14,'Lovmance','2025-06-03','2025-09-26','in_progress','2025-06-04 07:26:26.089267',1,20.0,3.0,2.0,25.0,2.0,3.0,20.0,25.0,4,17,3,2,21,2,3,17,21,0,0.0,1,'- UI/Ux Completed 

- Mobile App Design is ongoing'),
 (15,'Dhanubook','2025-06-03','2025-07-03','completed','2025-06-04 07:34:58.842159',1,35.0,10.0,0.0,25.0,10.0,0.0,0.0,10.0,1,8,2,0,6,2,0,0,2,2,10.0,1,'Delivered'),
 (16,'Aarogya Food','2025-06-09','2025-06-30','completed','2025-06-18 10:55:52.601512',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,16,0,0,0,0,0,0,0,0,0.0,1,'Delivered'),
 (17,'Om Tapovan','2025-06-09','2025-10-24','in_progress','2025-06-18 11:01:22.559892',1,30.0,0.0,0.0,20.0,0.0,0.0,20.0,20.0,1,30,0,0,20,0,0,20,20,10,10.0,1,'- Project is under Designing'),
 (18,'Star555','2025-06-09','2025-10-09','in_progress','2025-06-18 11:03:38.149580',1,60.0,0.0,0.0,0.0,0.0,0.0,20.0,10.0,1,53,0,0,0,0,0,18,9,9,10.0,1,'- Ui design completed 

- Project is under development - Frontend Team

- Require 3rd party API for that'),
 (19,'Gravity Drive','2025-06-12','2025-10-30','in_progress','2025-06-18 11:07:14.942028',1,55.0,0.0,0.0,10.0,0.0,0.0,20.0,10.0,3,56,0,0,10,0,0,20,10,5,5.0,1,'- Frontend Development is completed'),
 (20,'Swadpurti','2025-06-16','2025-07-16','completed','2025-06-18 11:08:37.018849',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,23,0,0,0,0,0,0,0,0,0.0,1,'- Delivered but not live'),
 (21,'Bapat Optics','2025-06-18','2025-09-26','in_progress','2025-06-18 11:10:23.823924',1,40.0,0.0,0.0,0.0,0.0,0.0,15.0,20.0,1,29,0,0,0,0,0,11,15,18,25.0,1,'- Ui design is ongoing'),
 (22,'One Trade Ai','2025-06-18','2025-07-31','in_progress','2025-06-18 11:12:02.294574',1,30.0,0.0,0.0,30.0,0.0,0.0,30.0,10.0,1,10,0,0,10,0,0,10,3,0,0.0,1,'- Ui completed 

- Now Moving for development'),
 (23,'My Wealth 2nd Phase','2025-06-18','2025-07-31','in_progress','2025-06-18 11:13:45.431608',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,32,0,0,0,0,0,0,0,0,0.0,1,'- Don''t Know the exact status'),
 (24,'Absar Money 2nd Phase','2025-06-02','2025-07-31','in_progress','2025-06-18 11:15:21.627151',1,50.0,0.0,0.0,50.0,0.0,0.0,0.0,0.0,2,22,0,0,22,0,0,0,0,0,0.0,1,'- Don''t know the exact status'),
 (25,'Game Katta 2nd phase','2025-06-02','2025-07-31','in_progress','2025-06-18 11:16:27.374533',1,40.0,0.0,0.0,40.0,0.0,0.0,0.0,20.0,2,18,0,0,18,0,0,0,9,0,0.0,1,'- Don''t know the exact status'),
 (26,'Coinzkart 2nd Phase Luxury','2025-01-01','2025-07-01','on_hold','2025-06-30 07:28:25.611525',1,0.0,0.0,0.0,0.0,0.0,0.0,0.0,100.0,1,0,0,0,0,0,0,0,130,0,0.0,0,'- Don''t know the exact status'),
 (27,'Netpurti','2024-02-01','2024-07-11','on_hold','2025-06-30 07:29:01.693464',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,116,0,0,0,0,0,0,0,0,0.0,0,'- No update on that project'),
 (28,'Boomerbuckz','2024-01-01','2024-08-24','in_progress','2025-06-30 07:30:04.096569',1,0.0,0.0,0.0,0.0,0.0,0.0,100.0,0.0,5,0,0,0,0,0,0,170,0,0,0.0,0,'- Vendor app design pending 

- Customer App testing pending 

- Website completed but not approved from client'),
 (29,'The Moon','2024-10-23','2025-02-28','in_progress','2025-06-30 07:31:11.880146',1,50.0,0.0,0.0,50.0,0.0,0.0,0.0,0.0,4,46,0,0,46,0,0,0,0,0,0.0,0,'- Small feedback received from client is pending from our end both from mobile app and backend'),
 (30,'Local Mandai','2023-12-08','2024-03-31','in_progress','2025-06-30 07:32:22.969021',1,50.0,0.0,0.0,50.0,0.0,0.0,0.0,0.0,4,40,0,0,40,0,0,0,0,0,0.0,0,'- Mobile App - Delivery boy app pending 

- Backend Api for Delivery boy pending'),
 (31,'Shubharambh','2024-07-31','2025-10-30','completed','2025-06-30 07:33:16.752348',1,0.0,0.0,0.0,0.0,0.0,0.0,100.0,0.0,5,0,0,0,0,0,0,327,0,0,0.0,0,'- Project Completed from our end but did not live on server'),
 (32,'IT Pulse','2024-01-01','2024-10-31','on_hold','2025-06-30 07:33:59.921603',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,219,0,0,0,0,0,0,0,0,0.0,0,'- Don''t Know the exact status of project'),
 (33,'Bhingari','2024-10-01','2025-01-31','in_progress','2025-06-30 07:34:55.018360',1,0.0,0.0,0.0,100.0,0.0,0.0,0.0,0.0,4,0,0,0,89,0,0,0,0,0,0.0,0,'- Don''t know the exact status of project'),
 (34,'JGM','2024-05-01','2024-09-25','in_progress','2025-06-30 07:42:01.014280',1,50.0,0.0,0.0,50.0,0.0,0.0,0.0,0.0,4,53,0,0,53,0,0,0,0,0,0.0,0,'- Pointers shared by client done , but confirmation pending from client side

- Mobile app pointers remaining'),
 (35,'Real Estate','2024-06-01','2024-08-03','on_hold','2025-06-30 07:42:40.831801',1,50.0,0.0,0.0,50.0,0.0,0.0,0.0,0.0,4,22,0,0,22,0,0,0,0,0,0.0,0,'- Mobile app shared but it is not working according to Client'),
 (36,'Printout Media','2024-10-31','2025-02-28','on_hold','2025-06-30 07:43:19.126783',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,87,0,0,0,0,0,0,0,0,0.0,0,'- Did not received any feedback from client end'),
 (37,'Icon Cabs','2024-06-19','2025-12-31','on_hold','2025-06-30 07:49:30.315205',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2,401,0,0,0,0,0,0,0,0,0.0,0,'- Project completed from our end .

- Client required SEO'),
 (38,'Pyros','2025-01-10','2025-03-19','on_hold','2025-06-30 07:50:18.679935',1,0.0,0.0,0.0,0.0,0.0,0.0,0.0,100.0,1,0,0,0,0,0,0,0,49,0,0.0,0,'-Not response from client side'),
 (39,'Flick and Shoot','2024-08-01','2024-12-31','completed','2025-06-30 07:50:58.527181',1,0.0,0.0,0.0,0.0,100.0,0.0,0.0,0.0,NULL,0,0,0,0,109,0,0,0,0,0.0,0,'- Client Cancelled the contract'),
 (40,'Painganga','2024-04-01','2024-11-28','on_hold','2025-06-30 07:51:47.912962',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4,174,0,0,0,0,0,0,0,0,0.0,0,'- According to client location is not working properly

- We worked on feedback but nothing works according to him

- Required Domain for mobile'),
 (41,'Bailgada','2024-01-01','2024-05-17','on_hold','2025-07-01 06:57:36.476909',1,0.0,0.0,0.0,0.0,0.0,0.0,0.0,100.0,1,0,0,0,0,0,0,0,100,0,0.0,0,'- Client is asking for 3D design , we provided the 2D design but , he is expecting something different'),
 (42,'Ayansh Internation','2025-06-30','2025-08-08','in_progress','2025-07-03 12:04:03.038634',1,0.0,0.0,0.0,0.0,5.0,0.0,0.0,35.0,1,0,0,0,0,2,0,0,10,18,60.0,1,'- Ui Design is going on'),
 (43,'Urban Build','2025-07-01','2025-10-24','in_progress','2025-07-03 12:59:36.177404',1,25.0,5.0,2.5,25.0,0.0,2.5,15.0,20.0,1,21,4,2,21,0,2,13,17,4,5.0,1,'-UI under Process'),
 (44,'Reachout Media','2024-12-01','2025-07-31','in_progress','2025-07-04 05:39:22.390205',1,50.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,7,87,0,0,0,0,0,0,0,87,50.0,1,'- Working on Finance Part

- CRM Completed'),
 (45,'Sahyadri Transport 2nd phase','2025-06-23','2025-07-11','completed','2025-07-04 05:55:36.113266',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,NULL,15,0,0,0,0,0,0,0,0,0.0,1,''),
 (46,'Nagma','2024-05-01','2024-11-01','in_progress','2025-07-04 13:54:18.959737',1,0.0,0.0,0.0,100.0,0.0,0.0,0.0,0.0,4,0,0,0,133,0,0,0,0,0,0.0,0,'- In Progress'),
 (47,'Dhagaa','2025-03-01','2025-04-03','in_progress','2025-07-07 09:54:34.349324',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,7,24,0,0,0,0,0,0,0,0,0.0,0,''),
 (48,'A2Z','2025-02-01','2025-04-30','in_progress','2025-07-08 04:56:08.615320',1,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,8,63,0,0,0,0,0,0,0,0,0.0,1,'');
INSERT INTO "projects_projectdocument" ("id","document","uploaded_at","project_id","uploaded_by_id") VALUES (1,'project_documents/Om_Tapovan_Event_WBS__APP.docx','2025-06-18 11:40:27.075814',17,1),
 (2,'project_documents/CONTRIVE_TECH_SOLUTIONS_WBS__APP_Agreement_1.docx','2025-07-08 10:56:08.007540',2,1);
INSERT INTO "projects_projectfeedback" ("id","project_id","created_at","date") VALUES (3,4,'2025-07-03 06:44:15.778761','2025-07-03'),
 (4,2,'2025-07-03 06:45:54.052351','2025-07-03'),
 (5,2,'2025-07-03 06:48:23.974124','2025-07-03'),
 (6,8,'2025-07-03 06:50:49.502183','2025-07-03'),
 (7,4,'2025-07-03 07:27:51.840908','2025-07-03'),
 (8,17,'2025-07-03 09:13:22.378217','2025-07-03'),
 (9,2,'2025-07-03 10:18:22.579794','2025-07-03'),
 (10,28,'2025-07-04 04:40:10.045578','2025-07-04'),
 (11,29,'2025-07-04 04:47:20.470259','2025-07-04'),
 (12,45,'2025-07-04 05:56:40.574714','2025-07-04'),
 (13,44,'2025-07-04 06:57:59.810467','2025-07-03'),
 (18,3,'2025-07-04 07:59:36.677202','2025-07-03'),
 (19,21,'2025-07-04 09:19:44.660463','2025-07-04'),
 (20,29,'2025-07-07 04:43:43.108055','2025-07-07'),
 (21,44,'2025-07-07 08:47:47.548145','2025-07-07'),
 (22,47,'2025-07-07 09:56:16.482238','2025-07-07'),
 (23,4,'2025-07-07 10:30:32.265237','2025-07-07'),
 (24,48,'2025-07-08 05:01:07.228400','2025-07-08'),
 (25,44,'2025-07-08 07:50:43.800260','2025-07-08'),
 (26,3,'2025-07-08 08:55:36.896667','2025-07-08'),
 (27,44,'2025-07-08 11:03:44.207755','2025-07-08');
INSERT INTO "projects_projectfeedback_users_to_notify" ("id","projectfeedback_id","user_id") VALUES (5,3,2),
 (6,3,3),
 (7,4,2),
 (8,4,3),
 (9,5,2),
 (11,6,2),
 (12,7,2),
 (13,7,3),
 (14,8,8),
 (15,8,17),
 (16,8,7),
 (17,9,2),
 (18,10,18),
 (19,10,3),
 (21,11,18),
 (22,11,19),
 (26,12,17),
 (27,12,19),
 (28,12,14),
 (29,10,17),
 (30,10,19),
 (31,10,15),
 (32,13,17),
 (33,13,19),
 (34,13,12),
 (39,18,17),
 (40,18,11),
 (41,19,8),
 (42,19,17),
 (43,19,10),
 (44,19,7),
 (45,20,17),
 (46,20,18),
 (47,20,19),
 (48,21,17),
 (49,21,19),
 (50,21,12),
 (51,22,3),
 (52,22,17),
 (53,22,19),
 (54,22,6),
 (55,23,3),
 (56,23,17),
 (57,23,19),
 (58,24,17),
 (59,24,19),
 (60,24,20),
 (61,25,12),
 (62,26,17),
 (63,26,11),
 (64,27,17),
 (65,27,12);
INSERT INTO "projects_projectfeedbackimage" ("id","feedback_id","content","image") VALUES (5,3,'ssssss','project_feedback/Screenshot_321_aDPvydO.png'),
 (6,4,'aaaaa','project_feedback/Screenshot_321_VzNg55F.png'),
 (7,5,'aaaa','project_feedback/Screenshot_321_RIVUq1m.png'),
 (8,5,'aaaaaa','project_feedback/Screenshot_320_IYoJn7r.png'),
 (9,6,'This','project_feedback/Screenshot_321_PQpV25T.png'),
 (10,6,'WEW','project_feedback/Screenshot_316.png'),
 (11,7,'aaaaaaa','project_feedback/WhatsApp_Image_2025-07-02_at_8.01.07_PM.jpeg'),
 (12,7,'ewefw','project_feedback/WhatsApp_Image_2025-07-02_at_3.56.15_PM.jpeg'),
 (13,8,'1. Explorer makes it the same as Sadguru explorer 

2. Shibir and Event Registration same as Sadguru 

3. A volunteer is okay','project_feedback/WhatsApp_Image_2025-07-03_at_2.42.57_PM.jpeg'),
 (14,8,'Shibir details like this','project_feedback/WhatsApp_Image_2025-07-03_at_2.44.11_PM.jpeg'),
 (15,9,'aaaaaaa','project_feedback/WhatsApp_Image_2025-07-03_at_2_Dau38rw.44.11_PM.jpeg'),
 (16,10,'Calendar error why not showing previous years from 2000?','project_feedback/WhatsApp_Image_2025-07-04_at_9.57.20_AM.jpeg'),
 (17,11,'No otp verification

Mandatory remove

Or skip page not showing



Only one catogery still offer products from other catogery showing','project_feedback/WhatsApp_Image_2025-07-04_at_12.26.59_AM.jpeg'),
 (18,11,'When adding 2nd catogery 1 st catogery''s subcategory showing','project_feedback/WhatsApp_Image_2025-07-04_at_12.28.09_AM.jpeg'),
 (19,11,'Added 3 catogery the sorting order not working, 1st added fruit and veg, 2nd icecream 3rd bathing','project_feedback/WhatsApp_Image_2025-07-04_at_12.29.51_AM.jpeg'),
 (20,11,'You can see here category adding order

Catogery page showing only last added catagory



KP store - credentials, hrskps@gmail.com 

Saha123@

Please check','project_feedback/WhatsApp_Image_2025-07-04_at_12.33.39_AM.jpeg'),
 (21,12,'Bank Details Still In Mandatory Phase While Filling The Details

Forgot Password OTP Not Working

And In Generate Invoice Give Delete Option','project_feedback/WhatsApp_Image_2025-06-28_at_2.08.14_PM_1.jpeg'),
 (22,10,'','project_feedback/WhatsApp_Video_2025-07-04_at_11.07.38_AM.mp4'),
 (23,13,'','project_feedback/Points_to_Profcyma_04-07-2025_1.pdf'),
 (28,18,'','project_feedback/Todo_ReportPage-03July25_1.xlsx'),
 (29,19,'In this section we request you to make some changes such as

1) adding frame details as well, like the Measurements and material.

2) a column for lens details should be added 

3) and a column for lens power / prescription.



The format for lens prescription I am sharing it with you','project_feedback/WhatsApp_Image_2025-07-04_at_2.44.10_PM.jpeg'),
 (30,19,'For Prescription/ lens power details','project_feedback/WhatsApp_Image_2025-07-04_at_3.10.32_PM.jpeg'),
 (31,20,'Added 7 catogeies, but showing only 5 in customer app','project_feedback/WhatsApp_Image_2025-07-04_at_10.55.07_PM.jpeg'),
 (32,20,'Showing only 5 catogeies, 2nd added Rice and grain not showed anywhere, in catogery page also','project_feedback/WhatsApp_Image_2025-07-04_at_10.58.24_PM.jpeg'),
 (33,20,'Catogery page showing only 3, but house hold showing in this page

Order by adding not working properly

In Fruits and veg catogery no products showing inside

Please check all these once more','project_feedback/WhatsApp_Image_2025-07-04_at_11.00.25_PM.jpeg'),
 (34,20,'Delivery boy shop wise payment showing wrong , see below total is different from above below total is correct today''s amount','project_feedback/WhatsApp_Image_2025-07-04_at_11.43.07_PM.jpeg'),
 (35,20,'Vendor app new order

 count not showing in home page , but inside page showing 1,

Today''s payment in home page zero, but inside page it''s showing perfect','project_feedback/WhatsApp_Image_2025-07-04_at_11.46.33_PM.jpeg'),
 (36,20,'See inside page ok','project_feedback/WhatsApp_Image_2025-07-04_at_11.48.26_PM.jpeg'),
 (37,20,'Delivery boy direct flow this page not showing, but come to home page shipped order all page flow is perfect','project_feedback/WhatsApp_Image_2025-07-04_at_11.48.59_PM.jpeg'),
 (38,20,'Delivery boy today''s order and payment ok . In order page but in today''s payment page wrong see below','project_feedback/WhatsApp_Image_2025-07-06_at_3.02.10_PM.jpeg'),
 (39,20,'Today''s payment page adding both store payment value, 987+79.9= 1066.9 showing both kpstore and kps rest.','project_feedback/WhatsApp_Image_2025-07-06_at_3.03.35_PM.jpeg'),
 (40,20,'Shop wise total also showing another value and wrong calculation','project_feedback/WhatsApp_Image_2025-07-06_at_3.08.17_PM.jpeg'),
 (41,20,'Vendor panel','project_feedback/WhatsApp_Image_2025-07-06_at_3.10.42_PM.jpeg'),
 (42,20,'Not removed add on, if we keep it same will effect billing format of restaurant also.','project_feedback/WhatsApp_Image_2025-07-06_at_3.11.11_PM.jpeg'),
 (43,20,'1. Make that Partner with: dhe Moon logo

2. Google.com change to www.dhemoon.com

This is our domain name already purchased

,','project_feedback/WhatsApp_Image_2025-07-06_at_3.17.10_PM.jpeg'),
 (44,21,'We are encountering this exception while trying to log in to crm.reachoutmeditech.com','project_feedback/WhatsApp_Image_2025-07-07_at_1.46.03_PM.jpeg'),
 (45,22,'','project_feedback/Website_updation_points_2.pdf'),
 (46,23,'CGSPL PO format.

Please note that in most of the cases (90 to 95% cases) "Ship To" address will be same as "Bill To" address. But there should be provision to change "Ship To" address if and when required.','project_feedback/CGSP_PO_Format.pdf'),
 (47,24,'','project_feedback/WhatsApp_Image_2025-07-08_at_12.08.18_AM.jpeg'),
 (48,24,'','project_feedback/WhatsApp_Image_2025-07-08_at_12.08.29_AM.jpeg'),
 (49,24,'','project_feedback/Screenshot_323.png'),
 (50,24,'','project_feedback/Screenshot_322.png'),
 (51,25,'sdcfffsf','project_feedback/Boomerbuks_Splash_screen_2__PP_4.mp4'),
 (52,26,'','project_feedback/WhatsApp_Image_2025-07-07_at_4.21.30_PM_1.jpeg'),
 (53,27,'As I encounter issues, I will be uploading them along with relevant images for your reference. Kindly review and address them accordingly.





-While doing proceed to QC 



if click on Update - getting this error','project_feedback/WhatsApp_Image_2025-07-08_at_3.40.13_PM.jpeg');
INSERT INTO "projects_task" ("id","title","description","status","priority","start_date","due_date","completed_at","created_at","assigned_by_id","assigned_to_id","project_id") VALUES (1,'New Task','-task','in_progress','medium','2025-07-01','2025-07-01','2025-07-01','2025-07-01 11:09:08.016372',1,12,35);
INSERT INTO "projects_teamprogress" ("id","assigned_start_date","expected_end_date","actual_end_date","rework_start_date","rework_end_date","delay_reason","remarks","updated_at","project_id","team_id") VALUES (3,'2025-06-30','2025-07-11',NULL,NULL,NULL,'none','- Currently working','2025-07-03 12:05:48.088528',42,1),
 (4,'2025-07-14','2025-08-06',NULL,NULL,NULL,'none','','2025-07-03 12:07:11.382924',42,3),
 (5,'2025-07-01','2025-07-23',NULL,NULL,NULL,'none','-Started','2025-07-04 05:27:17.249241',43,1),
 (6,'2025-06-12','2025-06-25','2025-06-27',NULL,NULL,'internal','','2025-07-08 07:47:09.709435',19,1);
INSERT INTO "teams_team" ("id","name","created_at") VALUES (1,'Ui/Ux Designer','2025-05-19 11:22:19.281379'),
 (2,'Backend Setup Admin Panel','2025-05-21 12:54:29.517165'),
 (3,'Frontend Development','2025-05-23 11:58:08.764442'),
 (4,'Mobile App Design','2025-05-23 12:08:56.669123'),
 (5,'Primary Testing','2025-05-27 11:45:03.015126'),
 (6,'Mobile App Integration','2025-07-03 11:34:58.467396'),
 (7,'Integration with website (Backend)','2025-07-03 11:36:49.375015'),
 (8,'Recurssive Testing','2025-07-03 11:37:31.557955');
INSERT INTO "teams_teammember" ("id","team_id","user_id") VALUES (2,2,3),
 (3,2,4),
 (4,2,2),
 (5,3,6),
 (6,2,5);
CREATE INDEX "auth_group_permissions_group_id_b120cbf9" ON "auth_group_permissions" ("group_id");
CREATE UNIQUE INDEX "auth_group_permissions_group_id_permission_id_0cd325b0_uniq" ON "auth_group_permissions" ("group_id", "permission_id");
CREATE INDEX "auth_group_permissions_permission_id_84c5c92e" ON "auth_group_permissions" ("permission_id");
CREATE INDEX "auth_permission_content_type_id_2f476e4b" ON "auth_permission" ("content_type_id");
CREATE UNIQUE INDEX "auth_permission_content_type_id_codename_01ab375a_uniq" ON "auth_permission" ("content_type_id", "codename");
CREATE INDEX "auth_user_groups_group_id_97559544" ON "auth_user_groups" ("group_id");
CREATE INDEX "auth_user_groups_user_id_6a12ed8b" ON "auth_user_groups" ("user_id");
CREATE UNIQUE INDEX "auth_user_groups_user_id_group_id_94350c0c_uniq" ON "auth_user_groups" ("user_id", "group_id");
CREATE INDEX "auth_user_user_permissions_permission_id_1fbb5f2c" ON "auth_user_user_permissions" ("permission_id");
CREATE INDEX "auth_user_user_permissions_user_id_a95ead1b" ON "auth_user_user_permissions" ("user_id");
CREATE UNIQUE INDEX "auth_user_user_permissions_user_id_permission_id_14a6b632_uniq" ON "auth_user_user_permissions" ("user_id", "permission_id");
CREATE INDEX "django_admin_log_content_type_id_c4bce8eb" ON "django_admin_log" ("content_type_id");
CREATE INDEX "django_admin_log_user_id_c564eba6" ON "django_admin_log" ("user_id");
CREATE UNIQUE INDEX "django_content_type_app_label_model_76bd3d3b_uniq" ON "django_content_type" ("app_label", "model");
CREATE INDEX "django_session_expire_date_a5c62663" ON "django_session" ("expire_date");
CREATE INDEX "projects_attachment_task_id_55727c8f" ON "projects_attachment" ("task_id");
CREATE INDEX "projects_attachment_uploaded_by_id_f2bd09cf" ON "projects_attachment" ("uploaded_by_id");
CREATE INDEX "projects_comment_task_id_37596e2f" ON "projects_comment" ("task_id");
CREATE INDEX "projects_comment_user_id_b974446a" ON "projects_comment" ("user_id");
CREATE INDEX "projects_dailytaskupdate_task_id_1585820c" ON "projects_dailytaskupdate" ("task_id");
CREATE INDEX "projects_dailytaskupdate_updated_by_id_47631737" ON "projects_dailytaskupdate" ("updated_by_id");
CREATE INDEX "projects_project_created_by_id_c49d7b6d" ON "projects_project" ("created_by_id");
CREATE INDEX "projects_project_project_progress_in_id_83230bd8" ON "projects_project" ("project_progress_in_id");
CREATE INDEX "projects_projectdocument_project_id_41155174" ON "projects_projectdocument" ("project_id");
CREATE INDEX "projects_projectdocument_uploaded_by_id_2e43c47e" ON "projects_projectdocument" ("uploaded_by_id");
CREATE INDEX "projects_projectfeedback_project_id_39b86c32" ON "projects_projectfeedback" ("project_id");
CREATE INDEX "projects_projectfeedback_users_to_notify_projectfeedback_id_9b4224db" ON "projects_projectfeedback_users_to_notify" ("projectfeedback_id");
CREATE UNIQUE INDEX "projects_projectfeedback_users_to_notify_projectfeedback_id_user_id_ab644ae9_uniq" ON "projects_projectfeedback_users_to_notify" ("projectfeedback_id", "user_id");
CREATE INDEX "projects_projectfeedback_users_to_notify_user_id_eaff6ad8" ON "projects_projectfeedback_users_to_notify" ("user_id");
CREATE INDEX "projects_projectfeedbackimage_feedback_id_f7fe28ba" ON "projects_projectfeedbackimage" ("feedback_id");
CREATE INDEX "projects_task_assigned_by_id_262f4504" ON "projects_task" ("assigned_by_id");
CREATE INDEX "projects_task_assigned_to_id_13b0183a" ON "projects_task" ("assigned_to_id");
CREATE INDEX "projects_task_project_id_a1b987d6" ON "projects_task" ("project_id");
CREATE INDEX "projects_teamprogress_project_id_2e8742fb" ON "projects_teamprogress" ("project_id");
CREATE INDEX "projects_teamprogress_team_id_b764405b" ON "projects_teamprogress" ("team_id");
CREATE INDEX "teams_teammember_team_id_09a01daf" ON "teams_teammember" ("team_id");
COMMIT;
