import pytz
from apscheduler.schedulers.background import BackgroundScheduler
from django.core.mail import send_mail
from django.conf import settings
import atexit

scheduler = None

def daily_report_mail():
    subject = " Projects"
    message = "This is your scheduled daily report mail."
    recipient_list = ["oshin.kawale@profcyma.com"]

    send_mail(subject, message, settings.DEFAULT_FROM_EMAIL, recipient_list)
    print("✅ Daily email sent")

def start_scheduler():
    global scheduler
    if scheduler is None:
        scheduler = BackgroundScheduler()

        # Always use IST for scheduling
        ist = pytz.timezone("Asia/Kolkata")

        # Times in IST
        target_times = [
            (14, 35),    # 9:00 AM IST
            (14, 36),  # 1:35 PM IST
            (14, 37),   # 6:00 PM IST
        ]

        for h, m in target_times:
            scheduler.add_job(
                daily_report_mail,
                "cron",
                hour=h,
                minute=m,
                timezone=ist  # <--- this makes it fire at IST time
            )
            print(f"📅 Job scheduled at {h:02d}:{m:02d} IST")

        scheduler.start()
        atexit.register(lambda: scheduler.shutdown())
