from django.db.models.signals import m2m_changed
from django.dispatch import receiver
from django.core.mail import EmailMessage
from django.conf import settings
from .models import ProjectFeedback

@receiver(m2m_changed, sender=ProjectFeedback.users_to_notify.through)
def send_feedback_email(sender, instance, action, pk_set, **kwargs):
    if action != "post_add":
        return

    subject = f"Feedback Recieved from {instance.project.name} on {instance.date}"

    # Get recipient emails
    recipient_list = list(instance.users_to_notify.values_list('email', flat=True))
    print("Recipient List:", recipient_list)

    # Collect feedback contents
    body_lines = ['Hello Team',"\n", "Kindly check the feedback recieved from client side"]
    for img in instance.images.all():
        if img.content:
            body_lines.append(f"- {img.content}")
    message = "\n".join(body_lines) if body_lines else "No description provided for images."

    email = EmailMessage(subject, message, settings.DEFAULT_FROM_EMAIL, recipient_list)

    # Attach each image
    for img in instance.images.all():
        if img.image:
            email.attach_file(img.image.path)

    email.send()


# signals.py
from django.db.models.signals import post_save
from django.dispatch import receiver
from django.contrib.auth.models import User
from .models import Profile

@receiver(post_save, sender=User)
def create_user_profile(sender, instance, created, **kwargs):
    if created:
        Profile.objects.create(user=instance)
