from django.db import models

# Create your models here.

from django.contrib.auth.models import User

class Team(models.Model):
    name = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return self.name


class TeamMember(models.Model):
    team = models.ForeignKey(Team, on_delete=models.CASCADE)
    user = models.OneToOneField(User, on_delete=models.CASCADE)

    def __str__(self):
        return f"{self.user.username} - {self.team.name}"


from django.db import models
from django.contrib.auth.models import User  # or your custom User model

class WeeklyMemberRating(models.Model):
    member = models.ForeignKey(User, on_delete=models.CASCADE, related_name='weekly_ratings')
    week_start_date = models.DateField()  # Monday of the week
    week_end_date = models.DateField()    # Sunday of the week

    rating = models.DecimalField(max_digits=4, decimal_places=2)  # e.g., 8.50 out of 10
    remarks = models.TextField(blank=True, null=True)

    created_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        unique_together = ('member', 'week_start_date')  # Prevent duplicate rating for the same member and week
        ordering = ['-week_start_date']

    def __str__(self):
        return f"{self.member.username} - Week of {self.week_start_date} - Rating: {self.rating}"
